/**
 * @brief Simple Semaphore using the mbed os demo
 */
#include "mbed.h"
#include "rtos.h"
#include "ST7567.h"

/* LCD and font parameters */
#define LCD_HEIGHT          64
#define LCD_WIDTH           128
#define FONT_HEIGHT         10
#define FONT_WIDTH          5

#define RT_TASK             0x8001
#define HP_TASK             0x8002


/* allocate statically stacks for the three threads */
unsigned char rt_stk[1024];
unsigned char hp_stk[1024];
unsigned char lp_stk[1024];

/* creates three tread objects with different priorities */
Thread real_time_thread(osPriorityRealtime, 1024, &rt_stk[0]);
Thread high_prio_thread(osPriorityHigh, 1024, &hp_stk[0]);
Thread low_prio_thread(osPriorityNormal, 1024, &lp_stk[0]);


/* crates a mutex that will help us to controll a resource access */
Mutex message_lock;

/* console buffer which has shared access */
char console_buffer[64] = {0};


/* creates a instance of display */
ST7567  disp(D11, D13, D12, D9, D10);

/**
 * @brief prints the current task which executes:
 */
static void log_thread(int t, int noof_exec) {
    
    /* try to take the mutex, or wait until becomes avalialble*/
    
    
    disp.cls();
    
    disp.locate(0, FONT_HEIGHT * 1);
    disp.printf("Thread status: ");

    disp.locate(0, FONT_HEIGHT * 2);  
    if(t ==  RT_TASK) {
        message_lock.lock();
        strcpy(&console_buffer[0], "-current thread: rt_task();\0" );    
        message_lock.unlock();
        disp.printf("%s", console_buffer);
    } else {
        message_lock.lock();
        strcpy(&console_buffer[0], "-current thread: hp_task();\0" );    
        message_lock.unlock();
        disp.printf("%s", console_buffer);
    }     

    disp.locate(0, FONT_HEIGHT * 3);
    disp.printf("-noof executions: %d ;", noof_exec);  
    disp.locate(0, FONT_HEIGHT * 4);
    disp.printf("-mutex status: taken .");
    

}


/**
 * @brief real time prio task function 
 */
static void rt_task(void) {    
    int execs = 0;
    
    
    for(;;) {
        execs++;
        log_thread(RT_TASK, execs);
        Thread::wait(2000);
    }
    
}

/**
 * @brief high prio task function 
 */
static void hp_task(void){    

    int execs = 0;
    
    for(;;) {
        execs++;
        log_thread(HP_TASK, execs);
        Thread::wait(2000);
    }
}

/**
 * @brief normal prio task function 
 */
static void np_task(void) {
    
    Thread::wait(0);        
    
    for(;;) {
         
    }
}

/**
 * @brief main loop 
 */
int main(void) {
    const char banner[] = {"Embarcados MBED-OS\0"};

    /* configures the display */
    disp.cls();
    disp.set_contrast(0x35);
    disp.locate((LCD_WIDTH - (sizeof(banner) * FONT_WIDTH)) / 2, (LCD_HEIGHT/2) - (FONT_HEIGHT/2));
    disp.printf(banner);
    
    Thread::wait(2500);
    disp.cls();

    /* starts the three tasks */
    real_time_thread.start(rt_task);   
    high_prio_thread.start(hp_task);   
    low_prio_thread.start(np_task);   


    return 0;
}

