/**
 *  @brief NXP FTF LAB0 - Prints a greeting message on GLCD
 */


#include "mbed.h"
#include "ST7567.h"

/* LCD screen dimensions */
#define LCD_HEIGHT          64
#define LCD_WIDTH           128

/* LCD font dimensions */
#define FONT_HEIGHT         10
#define FONT_WIDTH          5


/** Instance a on board GLCD object */
 ST7567 glcd(D11, D13, D12, D9, D10);

/**
 * @brief main application loop
 */
int main(void) 
{   
    const char msg[] = {"Welcome to NXP FTF !\0"};

    /* setup our on-board glcd */
    glcd.set_contrast(0x35);
    glcd.cls();
    
    /* Center the LCD cursor based on message size*/
    glcd.locate(LCD_WIDTH - (sizeof(msg) * FONT_WIDTH), 
                    (LCD_HEIGHT - FONT_HEIGHT) / 2);
    
    /* prints a welcome message */
    glcd.printf(msg);
    
    return 0;
}
