/**
 * @brief first thread control program with  MBED OS
 */
#include "mbed.h"
#include "rtos.h"

/* declares threads for this demo: */
const size_t a_stk_size = 1024;
uint8_t a_stk[a_stk_size];
Thread a_thread(osPriorityNormal, a_stk_size, &a_stk[0]);

const size_t b_stk_size = 1024;
uint8_t b_stk[b_stk_size];
Thread b_thread(osPriorityNormal, b_stk_size, &b_stk[0]);

/* reserve the debbuger uart to shell interface */
Serial pc_serial(USBTX,USBRX);


/**
 * @brief thread a function 
 */
static void thread_a(void)
{
    uint32_t execs = 0;
    pc_serial.printf("## started thread_a execution! ##\n\r");
 
    for(;;) {
        execs++;
        /* adds dummy processing */
        for(int i = 0 ; i < 0xFFFFFF; i++);
        pc_serial.printf("## thread_a executed %d times! ##\n\r", execs);
        a_thread.yield();
    }
}


/**
 * @brief thread a function 
 */
static void thread_b(void)
{
    uint32_t execs = 0;
    pc_serial.printf("## started thread_b execution! ##\n\r");
 
    for(;;) {
        execs++;
        /* adds dummy processing */
        for(int i = 0 ; i < 0xFFFFFF; i++);
        pc_serial.printf("## thread_b executed %d times! ##\n\r", execs);
        b_thread.yield();
    }
}



/**
 * @brief main application loop
 */
int main(void) 
{  
    pc_serial.baud(115200);
    a_thread.start(thread_a);
    b_thread.start(thread_b);
    return 0;
}