/**
 * @brief simple shel utility
 */
#ifndef __SHELL_H
#define __SHELL_H

#define SHELL_TXD USBTX
#define SHELL_RXD USBRX


/* define the shell command handler callback */
typedef int (*shell_callback_t) (char *cmd, int argc, char **argv, void *outchar);
typedef void (*shell_usage_t) (void *outchar);

/**
 * @brief set custom shell command handler 
 */
void shell_set_command_handler(shell_callback_t sh);


/**
 * @brief set the command list
 */
void shell_set_cmd_list(shell_usage_t sh);


/**
 * @brief start the shell character capturer
 */
void shell_start(void);

#endif