/**
 * @brief our first hello world threaded program with MBED OS
 */
#include "mbed.h"
#include "rtos.h"
#include "shell.h"


/** 
 * @brief create shell command handler 
 */
static int shell_callback(char *cmd, int argc, char **argv, void *outchar) 
{
    Serial *s = (Serial *)outchar;
    int ret = 0;
    if(strcmp("Hello", cmd) == 0){
        s->printf("## welcome to simple shell app, please add  your custom commands ##\n\r");
    }else {
        ret = -1;
    }
    return(ret);
}

/** 
 * @brief create shell command handler 
 */
static void shell_usage(void *outchar) 
{
    Serial *s = (Serial *)outchar;
    s->printf("## Hello - prints a hello world message ## \n\r");
}



/**
 * @brief main application loop
 */
int main(void) 
{   
    /* starts the shell task and applications task*/
    shell_set_command_handler(shell_callback);
    shell_set_cmd_list(shell_usage);
    shell_start();   
    return 0;
}