/**
 * @brief first thread control program with  MBED OS
 */
#include "mbed.h"
#include "rtos.h"

/* declares threads for this demo: */
const size_t a_stk_size = 1024;
uint8_t a_stk[a_stk_size];
Thread a_thread(osPriorityHigh, a_stk_size, &a_stk[0]);

const size_t b_stk_size = 1024;
uint8_t b_stk[b_stk_size];
Thread b_thread(osPriorityNormal, b_stk_size, &b_stk[0]);

/* Demo how to declare a semaphore */
Semaphore sema;


/* reserve the debbuger uart to shell interface */
Serial pc_serial(USBTX,USBRX);


/**
 * @brief thread a function 
 */
static void thread_a(void)
{
    pc_serial.printf("## started thread_a execution! ##\n\r");
 
    for(;;) {

        /* adds dummy processing */
        for(int i = 0 ; i < 0xFFFFFF; i++);
 
        pc_serial.printf("## thread_a will take the semaphore! ##\n\r");        
        //a_thread.yield();
        
        /* once executed, gives thread_a to do so, and sync the two tasks */
        sema.wait(osWaitForever);
        pc_serial.printf("## thread_a took the semaphore! ##\n\r");

    }
}


/**
 * @brief thread a function 
 */
static void thread_b(void)
{
    pc_serial.printf("## started thread_b execution! ##\n\r");
 
    for(;;) {
        
        /* adds dummy processing */
        for(int i = 0 ; i < 0xFFFFFF; i++);
        
        pc_serial.printf("## thread_b will signal the semaphore! ##\n\r");
        
        //b_thread.yield();
        
        /* release the semaphore and allow the high priority task to run */
        sema.release();
        pc_serial.printf("## thread_b signaled the semaphore, but thread_a consumed it! ##\n\r"); 
    }
}



/**
 * @brief main application loop
 */
int main(void) 
{  
    pc_serial.baud(115200);
    a_thread.start(thread_a);
    b_thread.start(thread_b);
    return 0;
}