/**
 * @brief first thread control program with  MBED OS
 */
#include "mbed.h"
#include "rtos.h"

/* declares threads for this demo: */
const size_t a_stk_size = 1024;
uint8_t a_stk[a_stk_size];
Thread a_thread(osPriorityNormal, a_stk_size, &a_stk[0]);

const size_t b_stk_size = 1024;
uint8_t b_stk[b_stk_size];
Thread b_thread(osPriorityNormal, b_stk_size, &b_stk[0]);

const size_t printer_stk_size = 2048;
uint8_t printer_stk[printer_stk_size];
Thread printer_thread(osPriorityHigh, printer_stk_size, &printer_stk[0]);

/* semaphore to simulate a io driver*/
Semaphore sema;

/* Mutex declared to share resource */
Mutex mtx;

/* reserve the debbuger uart to shell interface */
Serial pc_serial(USBTX,USBRX);

/* ram buffer to be acessed for both a and b threads */
char ram_console[1024];

/**
 * @brief thread a function 
 */
static void thread_a(void)
{
    const char message[] = {"thread_a writes: Hocus Pocus! Simsalabim!"};
 
    for(;;) {
        a_thread.wait(10);
        /* protect the resource */
        mtx.lock();
        memcpy(&ram_console, &message, sizeof(message)); 
        sema.release();
        /* release the protected resource */
        mtx.unlock();
    }
}


/**
 * @brief thread a function 
 */
static void thread_b(void)
{
    const char message[] = {"thread_b writes: Abracadabra!"};
 
    for(;;) {
        b_thread.wait(10);
        /* protect the resource */
        mtx.lock();
        memcpy(&ram_console, &message, sizeof(message));                 
        sema.release();
        /* release the protected resource */
        mtx.unlock();
    }
}

/**
 * @brief thread printer function 
 */
static void thread_printer(void)
{
     
    for(;;) {
        sema.wait(osWaitForever);
        /* prints the contents of buffer */        
        pc_serial.printf("##[PRINTER_OUT]: %s ## \n\r", ram_console);
          
         for(int i = 0; i < 0xFFFFFF; i++); 
                
        /* flushes the I/O console */        
        memset(&ram_console, 0, sizeof(ram_console));
    }
}


/**
 * @brief main application loop
 */
int main(void) 
{  
    pc_serial.baud(115200);
    a_thread.start(thread_a);
    b_thread.start(thread_b);
    printer_thread.start(thread_printer);
    return 0;
}