/**
 * @brief first thread control program with  MBED OS
 */
#include "mbed.h"
#include "rtos.h"

/* declares threads for this demo: */
const size_t a_stk_size = 1024;
uint8_t a_stk[a_stk_size];
Thread a_thread(osPriorityHigh, a_stk_size, &a_stk[0]);

const size_t b_stk_size = 1024;
uint8_t b_stk[b_stk_size];
Thread b_thread(osPriorityNormal, b_stk_size, &b_stk[0]);

/* define a request and reply struct */
typedef struct {
    char sender[64];
    char request[64];
    char how_much[64];
}request ;


typedef struct  {
    char responser[64];
    char response[64];
    char order[64];
}response;


/* reserve the debbuger uart to shell interface */
Serial pc_serial(USBTX,USBRX);

/* allocate a mail + memory pool combo to this demo */
Mail<request, 8> req_q;
Mail<response, 8>rep_q;
 

/**
 * @brief thread a function 
 */
static void thread_a(void)
{ 
    osEvent evt;
    int orders = 1;

    for(;;) {
        /* mount a request for the other thread: */
        request *r = req_q.alloc();
        if(r != NULL) {
            strcpy(&r->sender[0], "thread_a");
            strcpy(&r->request[0], "I want coffee, please!");
            strcpy(&r->how_much[0], "Two cups, with no sugar!");
            
            /* send the response to waiter task */
            req_q.put(r);
            
            /* waits for respose and post here */
            evt = rep_q.get(osWaitForever);
            response *rep = (response *)evt.value.p;
           
            /* prints the response */
            pc_serial.printf("## responser: %s ##\n\r", rep->responser);
            pc_serial.printf("## response: %s ##\n\r", rep->response);
            pc_serial.printf("## order: %s ##\n\r",rep->order);
            pc_serial.printf("## got the order: %d ## \n\r", orders++);
            /* freem memory */
            rep_q.free(rep);
            
            a_thread.wait(1000);
        } 
    }
}


/**
 * @brief thread a function 
 */
static void thread_b(void)
{
    osEvent evt;
    
    for(;;) {
        /* waits for respose and post here */
        evt = req_q.get(osWaitForever);
        request *req = (request *)evt.value.p;

        /* prints the response */
        pc_serial.printf("## sender: %s ##\n\r",req->sender);
        pc_serial.printf("## request: %s ##\n\r",req->request);
        pc_serial.printf("## how_muc: %s ##\n\r",req->how_much);
        req_q.free(req);

        response *r = rep_q.alloc();
        if(r != NULL) {
            strcpy(&r->responser[0], "thread_b");
            strcpy(&r->response[0], "Of course! here your coffe");
            strcpy(&r->order[0], "Two cups, hot, with no sugar!");
            /* send the response to waiter task */
            rep_q.put(r);            
        } 
    }
}



/**
 * @brief main application loop
 */
int main(void) 
{  
    pc_serial.baud(115200);
    a_thread.start(thread_a);
    b_thread.start(thread_b);
    return 0;
}