/**
 * @brief first event control program with  MBED OS
 */
#include "mbed.h"
#include "rtos.h"
#include "mbed_events.h"

/* declares threads for this demo: */
const size_t a_stk_size = 1024;
uint8_t a_stk[a_stk_size];
Thread a_thread(osPriorityNormal, a_stk_size, &a_stk[0]);

/* thread b is used as event loop thread*/
Thread b_thread;

/* queue used to handle events */
EventQueue ev_queue(32 * EVENTS_EVENT_SIZE);

/* reserve the debbuger uart to shell interface */
Serial pc_serial(USBTX,USBRX);

/* allocate HW for button with interrupt */
InterruptIn sw(SW2);


/**
 * @brief thread a function 
 */
static void thread_a(void)
{
    int pressed = 0;
    for(;;) {
        /* halt thread until a signal is received */
        a_thread.signal_wait(1, osWaitForever);
        pressed++;
        pc_serial.printf("## button press woke up this thread, noof presses: %d !##\n\r", pressed);
        pc_serial.printf("## now this thread will wait for a new press !##\n\r");        
    }
}


/**
 * @brief event callback called from thread context 
 */
static void button_callback(void) 
{
    /* button callback is used to assert a signal, 
     * this is the advantage of event loop, signals are not allowed
     * to use in ISR, but this callback is executed from thread
     * context
     */
     a_thread.signal_set(1);
}


/**
 * @brief main application loop
 */
int main(void) 
{  
    pc_serial.baud(115200);
    a_thread.start(thread_a);
    b_thread.start(callback(&ev_queue, &EventQueue::dispatch_forever));
    sw.rise(ev_queue.event(button_callback));
    return 0;
}