/*
 * An example of DC motor control, using NUCLEO-L476RG.
 *
 * Katedra za Elektroniku i digitalne sisteme
 * Elektrotehnicki fakultet
 * Beograd 
 *
 * Decembar 2021.
 *
 */

/*
 * Biblioteke za uvoz:
 */
#include "mbed.h"
#include "mb_pins.h"

/*
 * Definisanje makroa:
 */
#define DEBOUNCE_DELAY_MS 50
#define MOTOR_PERIOD_MS 100
 
/*
 * Globalne promenljive:
 */
InterruptIn motor_ctrl (MB_SW1);
AnalogOut motor_out(PA_5);  //SCK/D13
AnalogIn pot(MB_POT1);
// spin = 1 motor spins, spin = 0 motor stops:
char spin = 0; 
 
/*
 * Deklaracija funkcija:
 */
void ISR_ctrl(void);


/*
 * Glavna funkcija:
 */
int main()
{
    motor_ctrl.fall(&ISR_ctrl);
    while(1)
    { 
        if (spin)
        {
            motor_out.write(pot.read()); 
        }
        else
        {
            motor_out.write(0);  
        }
        wait_ms(MOTOR_PERIOD_MS);
    }
}
/*
 * Definicija funkcija:
 */
void ISR_ctrl(void){
    if(!motor_ctrl.read())
    {
        wait_ms(DEBOUNCE_DELAY_MS);
        if (!motor_ctrl.read()) spin = !spin;
    }
}