/*
 * An example of motor control, using step 28BYJ-48 motor and NUCLEO-L476RG.
 *
 * Katedra za Elektroniku i digitalne sisteme
 * Elektrotehnicki fakultet
 * Beograd 
 *
 * Decembar 2021.
 *
 */

/*
 * Biblioteke za uvoz:
 */
#include "mbed.h"
#include "mb_pins.h"

/*
 * Definisanje makroa:
 */
#define DEBOUNCE_DELAY_MS 50
#define MOTOR_PERIOD_MS 5
 
/*
 * Globalne promenljive:
 */
InterruptIn clkwise (MB_SW1);
//  D11 -  D10 -   D9   -   D8
// blue - pink - yellow - orange
BusOut motor_out(PA_7, PB_6, PC_7, PA_9);  
int step = 0; 
int dir = 0; // direction
 
/*
 * Deklaracija funkcija:
 */
void ISR_clkwise(void);


/*
 * Glavna funkcija:
 */
int main()
{
    clkwise.fall(&ISR_clkwise);
    while(1)
    { 
        switch(step)
        { 
            // Half-step control:
            case 0: motor_out = 0x1; break;  // 0001
            case 1: motor_out = 0x3; break;  // 0011
            case 2: motor_out = 0x2; break;  // 0010   
            case 3: motor_out = 0x6; break;  // 0110
            case 4: motor_out = 0x4; break;  // 0100
            case 5: motor_out = 0xC; break;  // 1100
            case 6: motor_out = 0x8; break;  // 1000
            case 7: motor_out = 0x9; break;  // 1001
            
            default: motor_out = 0x0; break; // 0000
        }
  
        if(dir) step++; else step--; 
        if(step>7)step=0; 
        if(step<0)step=7; 
        wait_ms(MOTOR_PERIOD_MS);  // speed
    }
}
/*
 * Definicija funkcija:
 */
void ISR_clkwise(void){
    if(!clkwise.read())
    {
        wait_ms(DEBOUNCE_DELAY_MS);
        if (!clkwise.read()) dir = !dir;
    }
}