/* Moving the rectangle previewed on the OLED display
 * by using potentiometers POT1 and POT2
 * 
 * November, 2021.
 */
#include "mbed.h"
#include "Adafruit_GFX.h"
#include "Adafruit_GFX_Config.h"
#include "Adafruit_SSD1306.h"

// I2C bus pins:
#define D_SDA                  PB_14 
#define D_SCL                  PB_13     
// I2C address, 60d or 0x3c:
#define I2C_REAL_ADD                                                        0x3c
#define I2C_ADDRESS                                            I2C_REAL_ADD << 1 
// Set OLED width and heigth [pixel]:
#define OLED_WIDTH_PX                                                        128
#define OLED_HEIGHT_PX                                                        64
// I2C frequency:
#define I2C_FREQUENCY                                                     400000
// Multipliers of POT1 and POT2 for OLED rectangle position:
#define WIDTH_SCALER                                                         128
#define HEIGHT_SCALER                                                         64
// Initial rectangle position:
#define INITIAL_X_POSITION                                     OLED_WIDTH_PX / 2
#define INITIAL_Y_POSITION                                    OLED_HEIGHT_PX / 2
// Refresh rate:
#define REFRESH_RATE_MS                                                        5
// Half of the potentiometer return value: 
#define HALF_INTERVAL                                                       0.5f   

// Initialize potentiometers' pins:
AnalogIn POT1(PA_0);
AnalogIn POT2(PA_1);

// Initialize I2C:
I2C i2c(PB_14,PB_13);

// Initialize OLED display:
Adafruit_SSD1306_I2c myOled(i2c,PB_5,I2C_ADDRESS,OLED_HEIGHT_PX,OLED_WIDTH_PX);
 
int main() {
  
    // Initialize OLED:
    myOled.begin();
    int x, y = 0;
//    i2c.frequency(I2C_FREQUENCY);
    while(true) { 
//        #ifdef GFX_WANT_ABSTRACTS
        x = (POT1 - HALF_INTERVAL)*WIDTH_SCALER;
        y = (POT2 - HALF_INTERVAL)*HEIGHT_SCALER;
        myOled.fillRect(x, y, OLED_WIDTH_PX, OLED_HEIGHT_PX, WHITE);
        myOled.display();
//        #endif 
        wait_ms(REFRESH_RATE_MS);
        myOled.clearDisplay();
  }
}
 