/* I2C scanner for NUCLEO-L476RG
 * 
 * November, 2021.
 */
#include "mbed.h"

#define D_SDA                  PB_14 
#define D_SCL                  PB_13 
#define MIN_ADD                    0
#define MAX_ADD                  127
#define DATA                     "00"
#define LENGTH                     1
#define SMALL_DELAY_MS            10       
#define BIG_DELAY                  2         

I2C i2c(D_SDA, D_SCL);
DigitalOut myled(LED1);
 
int ack;   
int address;
  
void scanI2C() {
  for(address = MIN_ADD; address < MAX_ADD; address++) {    
    ack = i2c.write(address << 1, DATA, LENGTH);
    if (!ack) {
       printf("\tFound at:   %3d <--> %3x\r\n", address,address);
    }    
    wait_ms(SMALL_DELAY_MS);
  } 
}
 
int main() {
  printf("I2C scanner \r\n");
  scanI2C();
  printf("Finished Scan\r\n");
  // just blink to let us know the CPU is alive 
  while(true) { 
      wait(BIG_DELAY);          
      myled = !myled;
  }
}
 