/*
 * Primer koriscenja prekida za STM32L476RG, napisan
 * koristeci mbed.h biblioteku. 
 *
 * Katedra za Elektroniku i digitalne sisteme
 * Elektrotehnicki fakultet
 * Beograd 
 *
 * Oktobar 2021.
 *
 */

/*
 * Biblioteke za uvoz:
 */
#include "mbed.h"

/*
 * Definisanje makroa:
 */
 
// Sledeci kod otkomentarisati
// da bi se videla demonstracija prioriteta prekida.
 /*
#define ON_TIME                                                                2
#define LED_ON                                                                 1
#define LED_OFF                                                                0
*/

/*
 * Globalne promenljive:
 */
InterruptIn button_sw2 (PC_8);     // Kreiranje promenljive tastera SW2
InterruptIn button_sw1 (PC_9);     // Kreiranje promenljive tastera SW1
DigitalOut led2_mb (PB_15);        // Kreiranje promenljive diode LED2
DigitalOut led1_mb (PA_11);        // Kreiranje promenljive diode LED1

/*
 * Deklaracija funkcija:
 */
void ISR_button_sw1 (void);
void ISR_button_sw2 (void);

/*
 * Glavna funkcija:
 */
int main()
{   
    // Inicijalizacija lokalnih promenljivih:
    // Ukljucivanje prekida na silaznu ivicu pinova tastera SW1 i SW2:
    button_sw2.fall(&ISR_button_sw2);
    button_sw1.fall(&ISR_button_sw1);
    
    // Funkcije koje se jedanput izvrsavaju:
    
    // Glavna petlja:
    while(true);    
}


/*
 * Definicija funkcija:
 */
// Prekidna rutina tastera:
void ISR_button_sw1()
{
    led1_mb = !led1_mb;
    // Prethodnu liniju zakomentarisati, a sledeci kod otkomentarisati
    // da bi se videla demonstracija prioriteta prekida.
    /*
    led1_mb.write(LED_ON);
    wait(ON_TIME);
    led1_mb.write(LED_OFF);
    */
}
void ISR_button_sw2()
{
    led2_mb = !led2_mb;
    // Prethodnu liniju zakomentarisati, a sledeci kod otkomentarisati
    // da bi se videla demonstracija prioriteta prekida.
    /*
    led2_mb.write(LED_ON);
    wait(ON_TIME);
    led2_mb.write(LED_OFF);
    */
}