/*
 * Primer ciklicne promene  intenziteta osvetljaja
 * korisnicke diode LD2 putem pritiska tastera USER,
 * napisan za STM32L476RG koristeci mbed.h biblioteku .
 *
 * Katedra za Elektroniku i digitalne sisteme
 * Elektrotehnicki fakultet
 * Beograd 
 *
 * Oktobar 2021.
 *
 */

/*
 * Biblioteke za uvoz:
 */
#include "mbed.h"

/*
 * Definisanje makroa:
 */
#define PWM_PERIOD 20
#define INITIAL_DUTY_CYCLE 0
#define DUTY_CYCLE_INCREMENT 0.25f
#define POLLING_PERIOD 50
#define MAX_DUTY_CYCLE 1

/*
 * Globalne promenljive:
 */
PwmOut DiodicaNaPloci(LED1);       // Kreiranje promenljive diode
DigitalIn TasterNaPloci (BUTTON1); // Kreiranje promenljive tastera

/*
 * Deklaracija funkcija:
 */
void ChangeLEDIntensity( void );   // Funkcija za promenu intenziteta
/*
 * Glavna funkcija:
 */
int main()
{
    // Inicijalizacija i funckije koje se jednom izvrsavaju:
    static char ButtonReleased = 0;           // Pomocna promenljiva stanja tastera
         
    // Prvo se zada period treperenja diode, a potom trajanje impulsa:
    DiodicaNaPloci.period_ms(PWM_PERIOD);  // Period treperenja traje 4 sekunde
    DiodicaNaPloci.write(INITIAL_DUTY_CYCLE); // Dioda ukljucena tokom 2
    
    while (true)
    {
        // Ukoliko je taster pritisnut (ima vrednost 0):
        if ( !TasterNaPloci )
        {
            // I ukoliko je prethodno bio nepritisnut (imao vrednost 1):
            if ( ButtonReleased )
            {
                ChangeLEDIntensity();   // Promeni se duty cycle po pravilu
                ButtonReleased = 0;     // Obelezi se da je taster pritisnut
            }
        }
        // Ako je taster nepritisnut:
        else
        {
            ButtonReleased = 1;    // Obelezi se da je taster nepritisnut
        }
        wait_ms( POLLING_PERIOD );   // Cekanje perioda poliranja
    } 
}

/*
 * Definicija funkcija:
 */
// Funkcija menja intenzitet osvetljaja diode tako sto menja duty cycle PWM-a
void ChangeLEDIntensity ()
{   
    static char MaxIntensityNotYetReached = 1;
    
    // Ukoliko jos uvek nije dostignut maksimum intenziteta:    
    if ( MaxIntensityNotYetReached )
    {
        // Kao vrednost duty cycle se upise stara vrednost i doda inkrement.
        DiodicaNaPloci.write( DiodicaNaPloci.read() + DUTY_CYCLE_INCREMENT );
        
        // Ukoliko je u prethodnoj liniji duty cycle dostigao 100%:
        if ( DiodicaNaPloci.read() == MAX_DUTY_CYCLE )
        {
            MaxIntensityNotYetReached = 0; // Prilikom sledeceg pritiska treba ga resetovati
        }  
    }
    // Ako je duty cycle prilikom prethodnog pritiska tastera dostigao 100%:    
    else
    {
        DiodicaNaPloci.write(INITIAL_DUTY_CYCLE);  // Treba ga resetovati na 0%
        MaxIntensityNotYetReached = 1;    // I obeleziti da nije dostigao maksimum     
    }

    return;
}