#include "mbed.h"
#include "Dht11.h"

//TICKERS CON FUNCIONES Y VARIABLES QUE SE USAN CON EL
Ticker sec;
void segundo();
int mandar = 0;
int contador = 0;

//SENSOR DE TEMPERATURA
Dht11 sensor(D2);
int temperatura = 0;

//ENTRADA DEL SENSOR DEL MOTOR
DigitalIn rpm(D3);

//SALIDA PWM PARA LA INTERFAZ DEL MOTOR
PwmOut motor(D4);

//ENTRADA ANALOGICA PARA EL PRESET
AnalogIn preset(A0);

//BOTON DE RESTART
Ticker boton;
DigitalIn restartButton(PTB8);
void button_in();
unsigned char state1 = 0x00;
int button_output = 0;

//MAQUINA DE ESTADOS CUENTA DE VUELTAS
void ME_RPM();
enum ME_RPM_ESTADOS { ESPERO_FA, ESPERO_FD };
ME_RPM_ESTADOS ME_RPM_ESTADO;
int cuenta_vueltas = 0;

//MAQUINA DE ESTADOS GENERAL
void ME_GENERAL();
enum ME_GENERAL_ESTADOS { LAZO_A, LAZO_C };
ME_GENERAL_ESTADOS ME_GENERAL_ESTADO;

//VARIABLE QUE GUARDA EL NIVEL DE DUTY QUE CALCULA EL PROGRAMA
float duty = 0;

int main()
{
    //INICIO EL MOTOR PRENDIDO AL MAXIMO PARA QUE SE LE PUEDA BAJAR EL DUTY POSTERIORMENTE
    
    motor = 1.0;
    wait(2);

    //PULLUP PARA LA ENTRADA DEL BOTON DE CAMBIO DE MODO
    restartButton.mode(PullUp);

    //TICKERS
    sec.attach(&segundo, 1);
    boton.attach(&button_in, 0.01);

    //ESTADO INICIAL MAQUINAS DE ESTADO
    ME_RPM_ESTADO = ESPERO_FA;
    ME_GENERAL_ESTADO = LAZO_A;

    while(1) {
        ME_RPM();
        ME_GENERAL();
        
        //CALCULO DE DUTY PARA CADA LAZO
        if(ME_GENERAL_ESTADO == LAZO_A) {
            if(preset < 0.035) { 
                duty = 0.035; // 200 RPM - 0.035
            } else {
                duty = preset;
            }
        } else {
            duty = temperatura < 20 ? 0.035 : temperatura / 70.0;
        }

        //ENVIO DE DATOS A LA PC
        if(mandar) {
            printf("T: %d, Modo: %d\r\n", sensor.getCelsius(), ME_GENERAL_ESTADO);
            printf("RPM: %d Duty: %f\r\n", cuenta_vueltas * 60, duty * 100);
            printf("Boton: %d\n\r", button_output);
            cuenta_vueltas = 0;
            mandar = 0;
            motor = duty;
        }
    }
}

//TICKER 1 seg
void segundo()
{
    //FLAG DE ENVIO DE DATOS A LA PC
    mandar = 1;
    
    //LECTURA DE LA TEMEPERATURA DEL SENSOR
    sensor.read();
    temperatura = sensor.getCelsius();
    
    //CONTADOR 1 seg
    contador++;
}

void ME_RPM()
{
    switch(ME_RPM_ESTADO) {
        case ESPERO_FA:
            //SI SE DETECTA UN FLANCO ASCENDENTE CAMBIO DE MODO
            if(rpm) {
                ME_RPM_ESTADO = ESPERO_FD;
                cuenta_vueltas++;
            }
            break;
        case ESPERO_FD:
            //SI SE DETECTA UN FLANCO DESCENDENTE CAMBIO DE MODO
            if(!rpm) {
                ME_RPM_ESTADO = ESPERO_FA;
            }
            break;
    }

}

void ME_GENERAL()
{
    switch(ME_GENERAL_ESTADO) {
        case LAZO_A:
            //SI SE APRIETA EL BOTON Y YA PASO UN SEGUNDO DESDE EL ULTIMO CAMBIO DE MODO SE PRODUCE UN CAMBIO
            if(button_output == 1 && contador > 1) {
                ME_GENERAL_ESTADO = LAZO_C;
                contador = 0;
            }
            break;
        case LAZO_C:
            //SI SE APRIETA EL BOTON Y YA PASO UN SEGUNDO DESDE EL ULTIMO CAMBIO DE MODO SE PRODUCE UN CAMBIO
            if(button_output == 1 && contador > 1) {
                ME_GENERAL_ESTADO = LAZO_A;
                contador = 0;
            }
            break;
    }
}

//MUESTREO DEL BOTON PARA ELIMINACION DEL REBOTE
void button_in()
{
    state1 = state1 >> 1;

    if(!restartButton) {
        state1 |= 0x80;
    }
    if(state1 == 0xFF)
        button_output = 1;
    else if(state1 == 0)
        button_output = 0;
}