#include "mbed.h"
#include "math.h"


// TIEMPOS INICIALES DEL SIMON
int button_time_out = 5000;
int time_led_on = 500;
int time_led_off = 500;

// SALIDA LED RGB
DigitalOut r(LED_RED);
DigitalOut g(LED_GREEN);
DigitalOut b(LED_BLUE);

// LECTURA DE RUIDO SRAND
AnalogIn ain(A0);

// ENTRADA DE BOTONES
DigitalIn boton_r(PTC1);
DigitalIn boton_g(PTC2);
DigitalIn boton_b(PTB3);
DigitalIn boton_y(PTB2);

// TICKERS
Ticker cont;
Ticker muestreo_botones;

int aleatorio(int min, int max); // FUNCION QUE DEVUELVE UN NUMERO ALEATORIO ENTRE min Y max

void color(int c); // FUNCION QUE PRENDE EL LED RGB EN UN COLOR SEGUN EL NUMERO c DE ENTRADA

// PULSAR BOTONES
int botones();
char botones_sr = 0; //0b0000 - YBGR
void entrada_botones();

// CONTADOR (1mS)
unsigned int cntTimeOut_1 = 0;
void contador();

// SECUENCIA
char secuencia[25] = {0}; // VECTOR QUE CONTIENE LA SECUENCIA DE COLORES
int cuenta_secuencia = 0; // VARIABLE QUE INDICA CUAN LARGA ES LA SECUENCIA (aumenta cada nivel)

// MAQUINA DE ESTADOS GENERAL
enum ME_GENERAL_ESTADOS {INICIO1, MOSTRAR, APRETAR, STOP1, GANASTE, DELAY1, DELAY2};
ME_GENERAL_ESTADOS ME_GENERAL_ESTADO;
int mostrando = 0;
int equivocado = 0;
int apretando = 0;
int ganar = 0;
void ME_GENERAL();

// MAQUINA DE ESTADOS MOSTRAR
enum ME_MOSTRAR_ESTADOS {INICIO2, ON, OFF};
ME_MOSTRAR_ESTADOS ME_MOSTRAR_ESTADO;
int mostrando_secuencia = 0;
void ME_MOSTRAR();

// MAQUINA DE ESTADOS APRETAR
enum ME_APRETAR_ESTADOS {INICIO3, ESPERO_BOTON, DELAY, DELAY3};
ME_APRETAR_ESTADOS ME_APRETAR_ESTADO;
int esperando_secuencia = 0;
int esperando_boton = 0;
void ME_APRETAR();
int boton_apretado = 0;

int main()
{
    srand(int(ain * 1000)); // SE USA EL RUIDO LEIDO

    cont.attach(&contador, 0.001f); // CONTADOR 1ms
    muestreo_botones.attach(&entrada_botones, 0.01); // MUESTREO DE BOTONES 10ms

    //ESTADOS INICIALES MAQUINAS DE ESTADO

    ME_GENERAL_ESTADO = INICIO1;
    ME_MOSTRAR_ESTADO = INICIO2;
    ME_APRETAR_ESTADO = INICIO3;

    //PULLUPS PARA LAS ENTRADAS

    boton_r.mode(PullUp);
    boton_g.mode(PullUp);
    boton_b.mode(PullUp);
    boton_y.mode(PullUp);

    while (true) {
        ME_GENERAL();
        ME_MOSTRAR();
        ME_APRETAR();
    }
}

int aleatorio(int min, int max)
{
    return rand() % (max - min + 1) + min;
}

void color(int c)
{
    switch(c) {
        case 0: //APAGADO
            r = 1;
            g = 1;
            b = 1;
            break;
        case 1: //ROJO
            r = 0;
            g = 1;
            b = 1;
            break;
        case 2: //VERDE
            r = 1;
            g = 0;
            b = 1;
            break;
        case 3: //AZUL
            r = 1;
            g = 1;
            b = 0;
            break;
        case 4: //AMARILLO
            r = 0;
            g = 0;
            b = 1;
            break;
        case 5: //BLANCO
            r = 0;
            g = 0;
            b = 0;
            break;
    }
}

int botones() // LECTURA DE LA VARIABLE botones_sr
{
    if((botones_sr & 0x01) != 0)
        return 1;
    else if((botones_sr & 0x02) != 0)
        return 2;
    else if((botones_sr & 0x04) != 0)
        return 3;
    else if((botones_sr & 0x08) != 0)
        return 4;
    else
        return 0;
}

void contador()
{
    cntTimeOut_1++;
    if(cntTimeOut_1 > 30000) // VALOR MAXIMO PARA QUE NUNCA SE PASE DEL LIMITE DEL INT
        cntTimeOut_1 = 0;
}

void ME_GENERAL()
{
    switch(ME_GENERAL_ESTADO) {
        default:
            ME_GENERAL_ESTADO = INICIO1;
            break;
        case INICIO1:
            color(0);
            //SI SE APRIETA UN BOTON SE INICIA EL MOSTRADO DE SECUENCIA
            if(botones() != 0) {
                ME_GENERAL_ESTADO = MOSTRAR;
                mostrando = 1;
                cntTimeOut_1 = 0;
            }
            break;
        case MOSTRAR:
            if(mostrando == 0) {
                ME_GENERAL_ESTADO = APRETAR;
                apretando = 1;
            }
            break;
        case APRETAR:
            if(apretando == 0) {
                if(equivocado == 0) {
                    if(ganar == 0) {
                        ME_GENERAL_ESTADO = MOSTRAR;
                        mostrando = 1;
                        // ACORTADO DE TIEMPOS
                        button_time_out -= 100;
                        time_led_on -= 10;
                        time_led_off -= 10;
                    } else {
                        ME_GENERAL_ESTADO = GANASTE;
                        cntTimeOut_1 = 0;
                    }
                }
                if(equivocado == 1) {
                    ME_GENERAL_ESTADO = STOP1;
                    cntTimeOut_1 = 0;
                }
            }
            break;
        case STOP1:
            r = 0;
            g = 1;
            b = 0;
            if(cntTimeOut_1 >= 1000) {
                ME_GENERAL_ESTADO = DELAY1;
            }
            break;
        case GANASTE:
            r = 1;
            g = 0;
            b = 0;
            if(cntTimeOut_1 >= 1000) {
                ME_GENERAL_ESTADO = DELAY1;
            }
            break;
        case DELAY1:
            if(botones() != 0) {
                ME_GENERAL_ESTADO = DELAY2;
                cntTimeOut_1 = 0;
            }
            break;
        case DELAY2:
            color(0);
            if(cntTimeOut_1 >= 1000) {
                ME_GENERAL_ESTADO = MOSTRAR;
                
                //REINICIO VARIABLES DE PARTIDA
                mostrando = 1;
                cuenta_secuencia = 0;
                button_time_out = 5000;
                time_led_on = 500;
                time_led_off = 500;
            }
            break;
    }
}

void ME_MOSTRAR()
{
    switch(ME_MOSTRAR_ESTADO) {
        default:
            ME_MOSTRAR_ESTADO = INICIO2;
            break;
        case INICIO2:
            if(mostrando == 1) {
                // AGREGADO DE COLOR A LA SECUENCIA
                secuencia[cuenta_secuencia] = aleatorio(1, 4);
                cuenta_secuencia++;
                if(cuenta_secuencia == 25) {
                    mostrando = 0;
                    apretando = 0;
                    ganar = 1;
                    break;
                } else {
                    mostrando_secuencia = 0;
                    cntTimeOut_1 = 0;
                    ME_MOSTRAR_ESTADO = ON;
                }
            }
            break;
        case ON:
            color(secuencia[mostrando_secuencia]);
            if(cntTimeOut_1 >= time_led_on) {
                ME_MOSTRAR_ESTADO = OFF;
                cntTimeOut_1 = 0;
            }
            break;
        case OFF:
            color(0);
            if(cntTimeOut_1 >= time_led_off) {
                if(mostrando_secuencia < (cuenta_secuencia-1)) {
                    mostrando_secuencia++;
                    ME_MOSTRAR_ESTADO = ON;
                    cntTimeOut_1 = 0;
                } else {
                    mostrando = 0;
                    ME_MOSTRAR_ESTADO = INICIO2;
                    cntTimeOut_1 = 0;
                }
            }
            break;
    }
}

void ME_APRETAR()
{
    switch(ME_APRETAR_ESTADO) {
        default:
            ME_APRETAR_ESTADO = INICIO3;
            break;
        case INICIO3:
            if(apretando == 1) {
                esperando_boton = 0;
                ME_APRETAR_ESTADO = ESPERO_BOTON;
                cntTimeOut_1 = 0;
            }
            break;
        case ESPERO_BOTON:
            boton_apretado = botones();
            color(0);
            if(cntTimeOut_1 >= button_time_out) {
                equivocado = 1;
                apretando = 0;
                ME_APRETAR_ESTADO = INICIO3;
            }

            if(boton_apretado != 0) {
                if(secuencia[esperando_boton] == boton_apretado) {
                        cntTimeOut_1 = 0;
                        ME_APRETAR_ESTADO = DELAY;
                } else {
                    equivocado = 1;
                    apretando = 0;
                    ME_APRETAR_ESTADO = INICIO3;
                }
            }
            break;
        case DELAY:
            color(boton_apretado);
            if(cntTimeOut_1 >= 250) {
                ME_APRETAR_ESTADO = DELAY3;
                cntTimeOut_1 = 0;
            }
            break;
        case DELAY3:
            color(0);
            if(cntTimeOut_1 >= 250 && esperando_boton < (cuenta_secuencia-1)) {
                esperando_boton++;
                ME_APRETAR_ESTADO = ESPERO_BOTON;
                cntTimeOut_1 = 0;
            } else if(cntTimeOut_1 >= 250 && esperando_boton >= (cuenta_secuencia-1)) {
                ME_APRETAR_ESTADO = INICIO3;
                equivocado = 0;
                apretando = 0;
                cntTimeOut_1 = 0;
            }
            break;
    }
}

void entrada_botones()
{

    static char state1 = 0x00; // VARIABLE BOTON 1
    state1 = state1 >> 1; // SE CORRE UN BIT A LA DERECHA
    if(!boton_r) {
        state1 |= 0x80; // SE LE SUMA UN 1 AL ULTIMO BIT
    }
    if(state1 == 0xFF)
        botones_sr |= 0b00000001; // SE PONE LA SALIDA EN UNO SI DURANTE 80ms SOLO SE LEYERON UNOS
    else if(state1 == 0)
        botones_sr &= 0b11111110; // SE PONE LA SALIDA EN CERO SI DURANTE 80ms SOLO SE LEYERON CEROS

    static char state2 = 0x00; //SE REPITE LO ANTERIOR PARA OTROS 3 BOTONES
    state2 = state2 >> 1;
    if(!boton_g) {
        state2 |= 0x80;
    }
    if(state2 == 0xFF)
        botones_sr |= 0b00000010;
    else if(state2 == 0)
        botones_sr &= 0b11111101;

    static char state3 = 0x00;
    state3 = state3 >> 1;
    if(!boton_b) {
        state3 |= 0x80;
    }
    if(state3 == 0xFF)
        botones_sr |= 0b00000100;
    else if(state3 == 0)
        botones_sr &= 0b11111011;

    static char state4 = 0x00;
    state4 = state4 >> 1;
    if(!boton_y) {
        state4 |= 0x80;
    }
    if(state4 == 0xFF)
        botones_sr |= 0b00001000;
    else if(state4 == 0)
        botones_sr &= 0b11110111;

}