#include "mbed.h"
#include "math.h"

//LED RGB
DigitalOut RGB_r(LED_RED);
DigitalOut RGB_g(LED_GREEN);

//SALIDA BCD
void numeros_bcd(int n);
BusOut unidades(D2, D3, D8, D9);
BusOut decenas(D4, D5, D6, D7);

//TICKERS
Ticker contador;
Ticker boton;
int mandar = 0;
void cuenta_seg();
unsigned int cuenta_descendente;
int estado_parpadeo = 0;

//PARPADEO
int partida_perdida = 0;
int partida_terminada = 0;

//BOTON DE RESTART
DigitalIn restartButton(PTB8);
void button_in();
unsigned char state1 = 0x00;
int button_output = 0;

//CABLES A DESCONECTAR
DigitalIn cable_1(PTE2);
DigitalIn cable_2(PTE3);
DigitalIn cable_3(PTE4);
DigitalIn cable_4(PTE5);
int cableDesconectado();
int n = 0; //INDICE DEL VECTOR cablesDesconectados
int cablesDesconectados[4] = {0};
int cablesPasados(int n); //DEVUELVE UN 1 SI SE HAYA n EN EL VECTOR cablesDesconectados
//MEDICION DE RUIDO PARA RAND
AnalogIn noise(PTC1);

//SECUENCIA
int secuencia[4];
int cuenta = 0;
void secuencia_aleatoria();

//MAQUINA DE ESTADOS GENERAL
void ME_GENERAL();
enum ME_GENERAL_ESTADOS {PAUSA,INICIO, COMPARO_CABLE_1, COMPARO_CABLE_2, COMPARO_CABLE_3, COMPARO_CABLE_4, GANASTE, PERDISTE };
ME_GENERAL_ESTADOS ME_GENERAL_ESTADO;


int main()
{
    //ESTADO INICIAL LEDS
    RGB_r = 1;
    RGB_g = 1;

    //PULLUP EN LAS ENTRADAS
    cable_1.mode(PullUp);
    cable_2.mode(PullUp);
    cable_3.mode(PullUp);
    cable_4.mode(PullUp);
    restartButton.mode(PullUp);

    //VALOR INICIAL DE LA CUENTA DESCENDENTE
    cuenta_descendente = 60;

    //TICKERS
    contador.attach(&cuenta_seg, 1);
    boton.attach(&button_in, 0.01);


    //GENERACION DE SECUENCIA ALEATORIA
    srand(int(noise * 10000));
    secuencia_aleatoria();



    ME_GENERAL_ESTADO = PAUSA;

    while(1) {
        //DETECCION DE CABLES DESCONECTADOS
        if(ME_GENERAL_ESTADO != PAUSA){
        cableDesconectado();

        //ENVIO DE DATOS A LA PC
        if(mandar) {
            printf("Cuenta: %d  Partida terminada: %d  Partida perdida: %d Reset: %d\n\r", cuenta_descendente, partida_terminada, partida_perdida, button_output);
            printf("Cables: [%d, %d, %d, %d] Secuencia: [%d %d %d %d]\n\r", cablesDesconectados[0], cablesDesconectados[1], cablesDesconectados[2], cablesDesconectados[3], secuencia[0], secuencia[1], secuencia[2], secuencia[3]);
            mandar = 0;
        }

        }
        ME_GENERAL();

        //PRENDIDO DE LOS DISPLAYS
        numeros_bcd(cuenta_descendente);
    }
}


//GENERACION DE SECUENCIA ALEATORIA
void secuencia_aleatoria()
{
    secuencia[0] = rand() % 4 + 1;
    for(int i = 1; i < 4; i++) {
        int randm = rand() % 4 + 1;
        int aux = 1;
        for(int j = 0; j < i; j++) {
            if(secuencia[j] == randm)
                aux = 0;
        }
        if(aux) {
            secuencia[i] = randm;
        } else {
            i--;
        }
    }
}

//MUESTREO DEL BOTON DE ENTRADA PARA LA ELIMINACION DEL REBOTE
void button_in()
{

    state1 = state1 >> 1;

    if(!restartButton) {
        state1 |= 0x80;
    }
    if(state1 == 0xFF)
        button_output = 1;
    else if(state1 == 0)
        button_output = 0;
}

//TICKER 1 seg
void cuenta_seg()
{
    mandar = 1; //FLAG PARA MANDAR DATOS

    //DESCUENTO
    if(cuenta_descendente > 0 && partida_terminada == 0 && ME_GENERAL_ESTADO != PAUSA)
        cuenta_descendente--;

    //CAMBIO ENTRE PRENDIDO Y APAGADO EL LED ROJO
    if(estado_parpadeo && partida_perdida) {
        RGB_r = 0;
    } else {
        RGB_r = 1;
    }

    estado_parpadeo = !estado_parpadeo;
}

void ME_GENERAL()
{
    switch(ME_GENERAL_ESTADO) {
        case PAUSA:
            if(button_output == 1) {
                secuencia_aleatoria();
                ME_GENERAL_ESTADO = INICIO;
            }
            break;
        case INICIO:
            RGB_r = 1;
            RGB_g = 1;
            //RESETEO VARIABLES DE PARTIDA
            n = 0;
            partida_perdida = 0;
            partida_terminada = 0;
            cuenta_descendente = 60;
            for(int i = 0; i < 4; i++)
                cablesDesconectados[i] = 0;

            ME_GENERAL_ESTADO = COMPARO_CABLE_1;
            break;
        case COMPARO_CABLE_1:
            //DETECTO SI SE DESCONECTO UN PRIMER CABLE Y COMPARO SI ES EL PRIMERO DE LA SECUENCIA ALEATORIA
            if(cablesDesconectados[0] != 0) {
                if(cablesDesconectados[0] == secuencia[0]) {
                    ME_GENERAL_ESTADO = COMPARO_CABLE_2;
                } else {
                    ME_GENERAL_ESTADO = PERDISTE;
                }
            }
            //SI SE ACABA EL TIEMPO SE VA AL ESTADO DE PERDISTE
            if(cuenta_descendente <= 0)
                ME_GENERAL_ESTADO = PERDISTE;
            break;
        case COMPARO_CABLE_2:
            if(cablesDesconectados[1] != 0) {
                if(cablesDesconectados[1] == secuencia[1]) {
                    ME_GENERAL_ESTADO = COMPARO_CABLE_3;
                } else {
                    ME_GENERAL_ESTADO = PERDISTE;
                }
            }
            if(cuenta_descendente <= 0)
                ME_GENERAL_ESTADO = PERDISTE;
            break;
        case COMPARO_CABLE_3:
            if(cablesDesconectados[2] != 0) {
                if(cablesDesconectados[2] == secuencia[2]) {
                    ME_GENERAL_ESTADO = COMPARO_CABLE_4;
                } else {
                    ME_GENERAL_ESTADO = PERDISTE;
                }
            }
            if(cuenta_descendente <= 0)
                ME_GENERAL_ESTADO = PERDISTE;
            break;
        case COMPARO_CABLE_4:
            if(cablesDesconectados[3] != 0) {
                if(cablesDesconectados[3] == secuencia[3]) {
                    ME_GENERAL_ESTADO = GANASTE;
                } else {
                    ME_GENERAL_ESTADO = PERDISTE;
                }
            }
            if(cuenta_descendente <= 0)
                ME_GENERAL_ESTADO = PERDISTE;
            break;
        case GANASTE:
            //SE PRENDE EL LED VERDE
            RGB_g = 0;

            //FLAG PARA EL PARPADEO
            partida_terminada = 1;


            if(button_output == 1) {
                secuencia_aleatoria();
                ME_GENERAL_ESTADO = INICIO;
            }
            break;
        case PERDISTE:
            //FLAGS PARA EL PARPADEO
            partida_perdida = 1;
            partida_terminada = 1;
            if(button_output == 1) {
                secuencia_aleatoria();
                ME_GENERAL_ESTADO = INICIO;
            }
            break;
    }
}

//FUNCION QUE LLENA EL VECTOR cablesDesconectados CON EL ORDEN Y NUMERO(IDENTIFICACION) DE CABLES DESCONECTADOS
int cableDesconectado()
{
    if(cable_1 == 1 && cablesPasados(1) == 0) {
        cablesDesconectados[n] = 1;
        n++;
        return 1;
    } else if(cable_2 == 1 && cablesPasados(2) == 0) {
        cablesDesconectados[n] = 2;
        n++;
        return 2;
    } else if(cable_3 == 1 && cablesPasados(3) == 0) {
        cablesDesconectados[n] = 3;
        n++;
        return 3;
    } else if(cable_4 == 1 && cablesPasados(4) == 0) {
        cablesDesconectados[n] = 4;
        n++;
        return 4;
    } else {
        return 0;
    }
}

//DEVUELVE UN 1 SI n SE HAYA EN cablesDesconectados
int cablesPasados(int n)
{
    for(int i = 0; i < 4; i++) {
        if(cablesDesconectados[i] == n) {
            return 1;
        }
    }

    return 0;
}

//FUNCION QUE PONE AL NUMERO n EN LOS DISPLAYS DE 7 SEGMENTOS
void numeros_bcd(int n)
{
    char un = n % 10;
    char dc = n / 10;

    if(estado_parpadeo && partida_terminada) {
        unidades = 0xF;
        decenas = 0xF;
    } else {
        unidades = un;
        decenas = dc;
    }

}