#include "mbed.h"
#include "Motor.h"
#include "rtos.h"
#include "ultrasonic.h"

// THREADS

Thread dispenseThread;

// BLUETOOTH
 
Serial blue(p28,p27);

// MOTOR

Motor ketch(p21, p11, p12); // pwm, fwd, rev

// DEBUG

DigitalOut debugLED(LED1);
DigitalOut errorLED(LED4);

// SONAR
int global_distance;

void dist(int a_distance)
{
    global_distance = a_distance;
}
ultrasonic mu(p6, p7, .1, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
                                        //have updates every .1 seconds and a timeout after 1
                                        //second, and call dist when the distance changes
// Servo ketch(p21);


bool ketchupDispensing = false;

void dispenseKetchup() {
 if (ketchupDispensing) {
    // already dispensing the ketch
    return; 
 }
 
 // set dispensing flag
 ketchupDispensing = true;
 
 //dispense
 ketch.speed(1.0f);
}

void stopDispenseKetchup() {
  if (!ketchupDispensing) {
    // not dispensing, you can't stop no ketch, so just return
    return;    
  }
  
  // unset dispensing flag
  ketchupDispensing = false;
  ketch.speed(0.0f);
  
  // turns debug LEDs off just in case
  debugLED = 0;
  errorLED = 0;
}

void dispenseSomeKetchup() {
    if (global_distance < 150) {
        debugLED = 1;
        printf("In thread, dispensing ketchup\n");
        dispenseKetchup();
        Thread::wait(1750);  
        stopDispenseKetchup();
        printf("Stopped dispense\n");
        debugLED = 0;
    } else {
        debugLED = 1;
        errorLED = 1;
        Thread::wait(1750);
        debugLED = 0;
        errorLED = 0;    
    }
}

void dispenseMuchKetchup() {
    if (global_distance < 150) {
        debugLED = 1;
        printf("In thread, dispensing ketchup\n");
        dispenseKetchup();
        Thread::wait(3500);  
        stopDispenseKetchup();
        printf("Stopped dispense\n");
        debugLED = 0;
    } else {
        debugLED = 1;
        errorLED = 1;
        Thread::wait(1750);
        debugLED = 0;
        errorLED = 0;    
    }
}

void dispenseKetchupInfinitely() {
    if (global_distance < 150) {
        debugLED = 1;
        printf("In thread, dispensing ketchup continuous\n");
        dispenseKetchup();
    } else {
        debugLED = 1;
        errorLED = 1;
        Thread::wait(1750);
        debugLED = 0;
        errorLED = 0;    
    }
}
  
int main()
{
    mu.startUpdates();//start measuring the distance
    debugLED = 1;
    ketch.speed(1.0f);
    Thread::wait(1000);
    ketch.speed(0.0f);
    debugLED = 0;
    while(1) {
        //Do something else here
        mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
        char bnum;
        if (blue.getc()=='!') {
            if (blue.getc()=='B') { //button data
                bnum = blue.getc(); //button number
                printf("bnum is %c", bnum);
                if ((bnum>='1')&&(bnum<='4')) //is a number button 1..4
                {
                    if (bnum == '1') {
                        // dispense some ketchup
                        printf("Starting thread\n");
                        dispenseThread.start(dispenseSomeKetchup);
                    } else if (bnum == '2') {
                        // dispense a lot of ketchup
                        dispenseMuchKetchup();
                    } else if (bnum == '3') {
                        // infinite ketchup
                        dispenseKetchupInfinitely();
                    } else if (bnum == '4') {
                        // stop dispense ketchup
                        stopDispenseKetchup();
                    }
                }
            }
        }
    }
}