//-------------------------------------------------------------
//  実行開始時のターミナルへメッセージの送信
//
//  2019/09/17, Copyright (c) 2019 MIKAMI, Naoki
//-------------------------------------------------------------

#include "mbed.h"
#pragma diag_suppress 870   // マルチバイト文字使用の警告抑制のため
#include <string>

enum AmFm { AM, FM };   // メッセージが AM 用か FM 用かを指定する

//      str     ２行目に表示するメッセージ
//      af      メーッセージが AM 用か FM 用かを指定
//      sp      メーッセージを出力するシリアルポート
void InitialMessage(string str, AmFm af, Serial &sp)
{
    sp.printf("\r\n");
    if (af == AM)
    {
        sp.printf("SDR で AM 放送を受信します．\r\n");
        sp.printf((str + "\r\n").c_str());
        sp.printf("0: NHK 第１\r\n1: NHK 第２\r\n2: AFN Tokyo\r\n3: TBS ラジオ\r\n"
                  "4: 東海ラジオ\r\n5: ｃｂｃ放送\r\n6: 岐阜ラジオ\r\n\n");
        sp.printf("'0' ～ '6' のキーで選局できます．\r\n");
        sp.printf("'0' ～ '6', 'Enter' キー以外は何も反応しません．\r\n");
    }
    else
    {
        sp.printf("\r\nSDR で FM 復調を実行します．\r\n");
        sp.printf((str + "\r\n").c_str());
        sp.printf("0 か 1 を入力してください．\r\n");
        sp.printf("'0', '1', 'Enter' キー以外は何も反応しません．\r\n");
    }
    
    sp.printf("'Enter' キーは CR/LF するだけです．\r\n\n");
    sp.putc('0');
}