//--------------------------------------------------------
//  STM32F446 内蔵の DAC 用のクラス（ヘッダ）
//      出力端子：   A2 (PA_4) に固定
//
//  2020/07/23, Copyright (c) 2020 MIKAMI, Naoki
//--------------------------------------------------------

#include "mbed.h"

#ifndef DAC_F446_SINGLE_HPP
#define DAC_F446_SINGLE_HPP

namespace Mikami
{
    class DacF446
    {
    public:
        // コンストラクタ， A2 に接続される CH1 のみを有効にする
        DacF446();

        virtual ~DacF446() {}

        // -1.0f <= data <= 1.0f
        void Write(float data) { WriteDac1(ToUint16(data)); }

    private:
        static const int BIT_WIDTH_ = 12;
        DAC_TypeDef* const DAC_;    // DA 変換器に対応する構造体のポインタ

        // DAC の CH1 へ右詰めで出力する
        void WriteDac1(uint16_t val) { DAC_->DHR12R1 = val; }

        // 飽和処理を行い uint16_t 型のデータを戻り値とする
        uint16_t ToUint16(float val)
        {   return __USAT((val + 1.0f)*2048.0f, BIT_WIDTH_); }

        // コピー･コンストラクタ，代入演算子の禁止のため
        DacF446(const DacF446&);
        DacF446& operator=(const DacF446&);
    };
}
#endif  // DAC_F446_SINGLE_HPP