#include "mbed.h"
#include "pwm_tone.h"
#include "MicroBit.h"

MicroBit uBit;
PwmOut Buzzer(MICROBIT_PIN_P0);
float c_2 = 1000000/523;
double sensori = 0;
double lampotila = 0;

double muunna_lampotilaksi(double arvo){
  return ((arvo * 3) / 1024 - 0.5) * 100;
}

int main(){
    uBit.init();     
    while (1){
        sensori = uBit.io.P1.getAnalogValue();
        lampotila = muunna_lampotilaksi(sensori);
        if(lampotila <= 30){
            Stop_tunes(Buzzer);                                  
        } else{
            Tune(Buzzer, c_2, 8);  
            wait_ms(250);
        }
    }   
} 