#include "main.h"
#include "morse.h"

#define M 0.1
#define V 0.5
#define LA 0.002272727

extern PwmOut spkr;

void to()
{
    spkr.period(LA);
    spkr=V;
    wait(M);
    spkr=0.0;
    wait(M);
}

void tsu()
{
    spkr.period(LA);
    spkr=V;
    wait(3.0*M);
    spkr=0.0;
    wait(M);
}

void one()
{
    to();
    wait(2.0*M);
}

void two()
{
    to();
    to();
    wait(2.0*M);
}

void three()
{
    to();
    to();
    to();
    wait(2.0*M);
}

void four()
{
    to();
    to();
    to();
    to();
    wait(2.0*M);
}

void five()
{
    to();
    to();
    to();
    to();
    to();
    wait(2.0*M);
}

void six()
{
    tsu();
    wait(2.0*M);
}

void seven()
{
    tsu();
    tsu();
    wait(2.0*M);
}

void eight()
{
    tsu();
    tsu();
    tsu();
    wait(2.0*M);
}

void nine()
{
    tsu();
    tsu();
    tsu();
    tsu();
    wait(2.0*M);
}

void zero()
{
    tsu();
    tsu();
    tsu();
    tsu();
    tsu();
    wait(2.0*M);
}

void period()
{
    to();
    tsu();
    to();
    tsu();
    to();
    tsu();
    wait(6.0*M);
}

void morse(int i)
{
    if(i>=0) i=i%10;
    switch(i%10)
    {
        case 1:
            one();
            break;
        case 2:
            two();
            break;
        case 3:
            three();
            break;
        case 4:
            four();
            break;
        case 5:
            five();
            break;
        case 6:
            six();
            break;
        case 7:
            seven();
            break;
        case 8:
            eight();
            break;
        case 9:
            nine();
            break;
        case 0:
            zero();
            break;
        default:
            period();
            break;
    }
}