#include "main.h"
#include "morse.h"

#define DO 0.003822258
#define RE 0.003405245
#define MI 0.003033728
#define FA 0.002863458
#define SO 0.002551050
#define LA 0.002272727

#define UT 0.2
#define BREATH 0.02
#define V 0.5

BusIn joy(p15,p12,p13,p16);
C12832 lcd(p5,p7,p6,p8,p11);
MMA7660 MMA(p28,p27);
LM75B sensor(p28,p27);
PwmOut spkr(p26);

void MSSRSMDR()
{
    spkr.period(DO); spkr=V;   wait(0.5*UT-BREATH); 
                     spkr=0.0; wait(BREATH);
    spkr.period(RE); spkr=V;   wait(0.5*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(MI); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(SO); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(SO); spkr=V;   wait(1.5*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(LA); spkr=V;   wait(0.5*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(SO); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(MI); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(DO); spkr=V;   wait(1.5*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(RE); spkr=V;   wait(0.5*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr=0.0;
}

void MMRDR()
{
    spkr.period(MI); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(MI); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(RE); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(DO); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(RE); spkr=V;   wait(3.0*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr=0.0;
}

void MMRRD()
{
    spkr.period(MI); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(MI); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(RE); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(RE); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(DO); spkr=V;   wait(4.0*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr=0.0;
}

void FFLLSMDR()
{
    spkr.period(FA); spkr=V;   wait(2.0*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(FA); spkr=V;   wait(2.0*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(LA); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(LA); spkr=V;   wait(3.0*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(SO); spkr=V;   wait(2.0*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(MI); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(DO); spkr=V;   wait(UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr.period(RE); spkr=V;   wait(3.0*UT-BREATH);
                     spkr=0.0; wait(BREATH);
    spkr=0.0;
}

void sing()
{
    MSSRSMDR();
    MMRDR();
    MSSRSMDR();
    MMRRD();
    FFLLSMDR();
    MSSRSMDR();
    MMRRD();
}

void temp(int i)
{
    if(i>=0)
    {
        i=i%100;
        morse(i/10);
        morse(i%10);
    }
}

int main()
{
    float x,y,z;
    while(1)
    {
        x=MMA.x();
        y=MMA.y();
        z=MMA.z();
        if(x*x+y*y+z*z>3.5) temp((int)sensor);
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("Temp = %d\n",(int)sensor);
        if(joy) sing();
        wait(0.02);
    }
}