//
// Wrapper for the WiFly module, using the serial port
//
// Copyright 2010 Pulse-Robotics, Inc.
// John Sosoka, Tyler Wilson
//

#include "wifly.h"


WiFly::WiFly(PinName tx, PinName rx)
    : port(0)
{
    port = new Serial(tx, rx);
    
    if (port)
    {
        port->baud(9600);
    }
}

void WiFly::commandMode() const
{
    if (port)
    {
        port->printf("$$$");
        // wait for 250ms
                
        char result[4];
        port->scanf("%c%c%c", result[0], result[1], result[2]);
        result[3] = 0;
        
        if (strcmp(result, "CMD") != 0)
        {
            // not the expected reply
        }
    }
}

void WiFly::dataMode() const
{
    if (port)
    {
        port->printf("exit\r");

        char result[5];
        port->scanf("%c%c%c%c", result[0], result[1], result[2], result[3]);
        result[4] = 0;
        
        if (strcmp(result, "EXIT") != 0)
        {
            // not the expected reply
        }
    }
}


// Serial methods
void WiFly::baud(int baudrate)
{
    port->baud(baudrate);
}

int WiFly::getc()
{
    return port->getc();
}

void WiFly::putc(int c)
{
    port->putc(c);
}

int WiFly::readable()
{
    return port->readable();
}

