/**
 * Wrapper for the WiFly module, using the serial port.
 *
 * Copyright 2010 Pulse-Robotics, Inc.
 * John Sosoka, Tyler Wilson
 */

#ifndef __wifly_h__
#define __wifly_h__

#include "mbed.h"


class WiFly {

public:
    /** Create a WiFly object connected to the specified serial pins
     *
     * @param tx TX pin of the Serial port
     * @param rx RX pin of the Serial port 
     */
    WiFly(PinName tx, PinName rx);

    void commandMode() const;
    void dataMode() const;
    
    // Serial methods. Could also derive from Serial...
    void baud(int baudrate=9600);
    int getc();
    void putc(int c);
    int readable();
    
private:
    Serial* port;
};


#endif /* __wifly_h__ */