// Copyright (C) 2018 Analog Devices, Inc. - All Rights Reserved
#include "mbed.h"

I2C i2c(D4, D5); // I2C i2c(D14, D15);
DigitalIn gpio0(D9);
Serial serial(PA_2, PA_15, 115200); //Serial serial(D0, D1, 115200);

uint16_t ADPD_Read_Register(uint8_t register_address)
{
    char data[1] = {register_address};
    char buffer[2];
    i2c.write(0xC8, data, 1);
    i2c.read(0xC9, buffer, 2);
    uint16_t register_value = buffer[0]*256 + buffer[1];
    return(register_value);
}

void ADPD_Write_Register(uint8_t register_address, uint16_t register_value)
{
    char data[3];
    data[0] = register_address;
    data[1] = register_value>>8;
    data[2] = register_value;
    i2c.write(0xC8, data, 3);
}

void ADPD_Load_Config(void)
{
    ADPD_Write_Register(0x10, 0x0001);
    ADPD_Write_Register(0x00, 0x80FF);
    ADPD_Write_Register(0x01, 0x01EF);
    ADPD_Write_Register(0x02, 0x0005);
    ADPD_Write_Register(0x06, 0x0000);
    ADPD_Write_Register(0x11, 0x300B);
    ADPD_Write_Register(0x12, 0x0050);
    ADPD_Write_Register(0x14, 0x0555);
    ADPD_Write_Register(0x15, 0x0000);
    ADPD_Write_Register(0x18, 0x1F00);
    ADPD_Write_Register(0x19, 0x1F00);
    ADPD_Write_Register(0x1A, 0x1F00);
    ADPD_Write_Register(0x1B, 0x1F00);
    ADPD_Write_Register(0x23, 0x303F);
    ADPD_Write_Register(0x25, 0x02CC);
    ADPD_Write_Register(0x26, 0x0A00);
    ADPD_Write_Register(0x28, 0x0050);
    ADPD_Write_Register(0x30, 0x0319);
    ADPD_Write_Register(0x31, 0x0813);
    ADPD_Write_Register(0x34, 0x0000);
    ADPD_Write_Register(0x39, 0x21FB);
    ADPD_Write_Register(0x3C, 0x3006);
    ADPD_Write_Register(0x42, 0x1C34);
    ADPD_Write_Register(0x43, 0xADA5);
    ADPD_Write_Register(0x4B, 0x2695);
    ADPD_Write_Register(0x54, 0x0AA0);
}

int main() {
    i2c.frequency(400000);
    
    ADPD_Load_Config();
    ADPD_Write_Register(0x10, 0x0002);
    uint16_t G;
    
    while(1) {
        if (gpio0 == 0) {
            G = ADPD_Read_Register(0x60);
            ADPD_Write_Register(0x00, 0x80FF);
            
            if ((G>>7) & 0x01) {
                serial.printf("click\n\r");
            } else if ((G>>6) & 0x01) {
                serial.printf("down\n\r");
            } else if ((G>>5) & 0x01) {
                serial.printf("up\n\r");
            } else if ((G>>4) & 0x01) {
                serial.printf("right\n\r");
            } else if ((G>>3) & 0x01) {
                serial.printf("left\n\r");
            }
        }
    }
}