// Copyright (C) 2018 Analog Devices, Inc. - All Rights Reserved
#include "mbed.h"
#include "arm_math.h"

I2C i2c(D4, D5); // I2C i2c(D14, D15);
DigitalIn gpio0(D9);
Serial serial(PA_2, PA_15, 115200); //Serial serial(D0, D1, 115200);

#define W 5
#define NTAPS 25

volatile float32_t x_YT[W], x_YB[W], x_XL[W], x_XR[W];

float32_t coefs[10]={0.310235, 0, -0.310235, -0.602633, -0.379530, 0.310235, 0, -0.310235, -0.602633, -0.379530};
float32_t state_vars[8];
arm_biquad_casd_df1_inst_f32 filter;

float32_t Q_taps[NTAPS]={1.000000, -0.409069, -0.665326,  0.953396, -0.114683, -0.859570,  0.817929,  0.190391,
       -0.973695,  0.606225,  0.477720, -0.997066,  0.338017,  0.720522, -0.927502,  0.038303,
        0.896166, -0.771489, -0.264982,  0.988280, -0.543568, -0.543568,  0.988280, -0.264982,
       -0.771489};

float32_t I_taps[NTAPS]={0.000000,  0.912504, -0.746553, -0.301721,  0.993402, -0.511019, -0.575319,  0.981708,
       -0.227854, -0.795293,  0.878512,  0.076549, -0.941140,  0.693433,  0.373817, -0.999266,
        0.443720,  0.636242, -0.964253,  0.152649,  0.839365, -0.839365, -0.152649,  0.964253,
       -0.636242};

uint16_t ADPD_Read_Register(uint8_t register_address)
{
    char data[1] = {register_address};
    char buffer[2];
    i2c.write(0xC8, data, 1);
    i2c.read(0xC9, buffer, 2);
    uint16_t register_value = buffer[0]*256 + buffer[1];
    return(register_value);
}

void ADPD_Write_Register(uint8_t register_address, uint16_t register_value)
{
    char data[3];
    data[0] = register_address;
    data[1] = register_value>>8;
    data[2] = register_value;
    i2c.write(0xC8, data, 3);
}

void ADPD_Load_Config(void)
{
    ADPD_Write_Register(0x10, 0x0001);
    ADPD_Write_Register(0x00, 0x80FF);
    ADPD_Write_Register(0x01, 0x01BF);
    ADPD_Write_Register(0x02, 0x0005);
    ADPD_Write_Register(0x06, 0x0000);
    ADPD_Write_Register(0x11, 0x3120);
    ADPD_Write_Register(0x12, 0x000D);
    ADPD_Write_Register(0x14, 0x0550);
    ADPD_Write_Register(0x15, 0x0000);
    ADPD_Write_Register(0x1E, 0x1F00);
    ADPD_Write_Register(0x1F, 0x1F00);
    ADPD_Write_Register(0x20, 0x1F00);
    ADPD_Write_Register(0x21, 0x1F00);
    ADPD_Write_Register(0x34, 0x0000);
    ADPD_Write_Register(0x35, 0x0210);
    ADPD_Write_Register(0x36, 0x5E0E);
    ADPD_Write_Register(0x3B, 0x20F4);
    ADPD_Write_Register(0x3C, 0x3006);
    ADPD_Write_Register(0x44, 0x1C37);
    ADPD_Write_Register(0x45, 0xADA5);
    ADPD_Write_Register(0x4B, 0x2695);
    ADPD_Write_Register(0x54, 0x0AA0);
    
    ADPD_Write_Register(0x58, 0x0820);
    ADPD_Write_Register(0x1D, 0x0006);
}

void get_window(void)
{
    uint8_t r = 0;
    
    ADPD_Write_Register(0x10, 0x0002);
    while(r<W+1) {
        if (gpio0 == 0) {
            if (r==0) {
                ADPD_Read_Register(0x68);
                ADPD_Read_Register(0x69);   
                ADPD_Read_Register(0x6A);   
                ADPD_Read_Register(0x6B);
                ADPD_Write_Register(0x00, 0x80FF);
            } else {
                x_YT[r-1] = ADPD_Read_Register(0x68);
                x_YB[r-1] = ADPD_Read_Register(0x69);
                x_XL[r-1] = ADPD_Read_Register(0x6A);
                x_XR[r-1] = ADPD_Read_Register(0x6B);
                ADPD_Write_Register(0x00, 0x80FF);
            }
            r++;
        }
    }
    ADPD_Write_Register(0x10, 0x0000);
}


float32_t demod(float32_t* x)
{
    float32_t min_val, max_val, temp;
    uint32_t jnk;
    arm_max_f32(x, W, &max_val, &jnk);
    arm_min_f32(x, W, &min_val, &jnk);
    temp = max_val - min_val;

    return temp;
}


int main() {
    float32_t d_YT = 0, d_YB = 0, d_XL = 0,d_XR = 0;
    float32_t Xangle = 0, Yangle = 0;
    arm_biquad_cascade_df1_init_f32(&filter,2,coefs,state_vars);
    i2c.frequency(400000);    
    ADPD_Load_Config();
    int decimate = 4;
    int i = 0;
    while(1) {
        d_YT = 0;
        d_YB = 0;
        d_XL = 0;
        d_XR = 0;
        for(i=0;i<decimate;i++) {
            get_window();
            d_YT += demod( (float32_t*) x_YT);
            d_YB += demod( (float32_t*) x_YB);
            d_XL += demod( (float32_t*) x_XL);
            d_XR += demod( (float32_t*) x_XR);
        }
        Xangle = (d_XL - d_XR)/(d_XL + d_XR) / 0.005;
        Yangle = (d_YT - d_YB)/(d_YT + d_YB) / 0.005;
        serial.printf("# %2.5f %2.5f\n\r", Xangle, Yangle);
    }
}