#include "qp_port.h"
#include "hangman.h"
#include "bsp.h"
#include "LPC17xx.h"
#include "mbed.h"

Q_DEFINE_THIS_FILE

enum ISR_Priorities { // ISR priorities from highest urgency to lowest
    BUTTON_PRIO,
    SYSTICK_PRIO,
};


#define LED_PORT      LPC_GPIO1
#define LED1_BIT     (1U << 18)
#define LED2_BIT     (1U << 20)
#define LED3_BIT     (1U << 21)
#define LED4_BIT     (1U << 23)

//............................................................................
extern "C" void SysTick_Handler(void) {
    QK_ISR_ENTRY();                // inform the QK kernel of entering the ISR

#ifdef Q_SPY
    uint32_t volatile dummy = SysTick->CTRL; // clear the COUNTFLAG in SysTick
    l_tickTime += l_tickPeriod;              // account for the clock rollover
#endif

    QF::TICK(&l_SysTick_Handler);             // process all armed time events

    QK_ISR_EXIT();                  // inform the QK kernel of exiting the ISR
}

//............................................................................
void BSP_init(void) {
    SystemInit();                            // initialize the clocking system

    // set LED port to output
    LED_PORT->FIODIR |= (LED1_BIT | LED2_BIT | LED3_BIT | LED4_BIT);

    // clear the LEDs
    LED_PORT->FIOCLR  = (LED1_BIT | LED2_BIT | LED3_BIT | LED4_BIT);

    QS_OBJ_DICTIONARY(&l_SysTick_Handler);
}

//............................................................................
void BSP_lcdScrollIn(char* line1, char* line2) {
// scroller algorithm
    lcd.cls();
    char output1[17];
    char output2[17];
    for ( int i = 0; i < 17; i++) {
        output1[i] = ' ';
        output2[i] = ' ';
    }
    for (int i = 0; i < 17; i++) {
        for (int col = 0; col < 17; col++) {

            if (col >= i) {
                output1[col] = ' ';
                output2[col] = ' ';
            } else {
                output1[col] = (line1[col+(16-i)]);
                output2[col] = (line2[col+(16-i)]);
            }
            lcd.locate(col,0);
            lcd.putc(output1[col]);
            lcd.locate(col,1);
            lcd.putc(output2[col]);
        }
        wait(0.4);
    }
}

//............................................................................
void BSP_lcdUpdate(char* line1,char* line2) {
    uint8_t length1 = strlen(line1);
    uint8_t length2 = strlen(line2);
    if (length1 > length2)
        length1 = length2;
    lcd.cls();
    if (length1 < 17)
        for (int col = 0; col < 17 && col < length1; col++) {
            lcd.locate(col,0);
            lcd.putc(*(line1+col));
            lcd.locate(col,1);
            lcd.putc(*(line2+col));
        }
    else
        for (int col = 0; col < 17; col++) {
            lcd.locate(col,0);
            lcd.putc(*(line1+col));
            lcd.locate(col,1);
            lcd.putc(*(line2+col));
        }
}

//............................................................................
void QF::onStartup(void) {
    // set up the SysTick timer to fire at BSP_TICKS_PER_SEC rate
    SysTick_Config(SystemCoreClock / BSP_TICKS_PER_SEC);

    // set priorities of all interrupts in the system...
    NVIC_SetPriority(SysTick_IRQn, SYSTICK_PRIO);
    //NVIC_SetPriority(EINT0_IRQn,   GPIOPORTA_PRIO);

    //NVIC_EnableIRQ(EINT0_IRQn);
}
//............................................................................
void QF::onCleanup(void) {
}
//............................................................................
void QK::onIdle(void) {

    QF_INT_LOCK(dummy);
    LED_PORT->FIOSET = LED4_BIT;                           // turn the LED4 on
    __NOP();                        // delay a bit to see some light intensity
    __NOP();
    __NOP();
    __NOP();
    LED_PORT->FIOCLR = LED4_BIT;                          // turn the LED4 off
    QF_INT_UNLOCK(dummy);

    __WFI();
}

//............................................................................
void Q_onAssert(char const Q_ROM * const Q_ROM_VAR file, int line) {
    (void)file;                                      // avoid compiler warning
    (void)line;                                      // avoid compiler warning
    QF_INT_LOCK(dummy);          // make sure that all interrupts are disabled
    // light up all LEDs
    LED_PORT->FIOSET = (LED1_BIT | LED2_BIT | LED3_BIT | LED4_BIT);

    for (;;) {          // NOTE: replace the loop with reset for final version
    }
}