#include "qp_port.h"
#include "dpp.h"
#include "bsp.h"

Q_DEFINE_THIS_FILE

class Player : public QActive {
private:
    QTimeEvt m_timeEvt;                       // to timeout update joystick pos
    uint8_t wins;
    uint8_t losses;

public:
    Player();

private:
    static QState initial (Player *me, QEvent const *e);
    static QState thinking(Player *me, QEvent const *e);
    static QState playing (Player *me, QEvent const *e);
};

static Player l_player;

#define JOY_TIME    (BSP_TICKS_PER_SEC/5) // update joystick position every 5 ticks

enum InternalSignals {                                     // internal signals
    TIMEOUT_SIG = MAX_SIG
};

QActive * const AO_Player = l_player;

//............................................................................
Player::Player()
    : QActive((QStateHandler)&Player::initial),
      m_timeEvt(TIMEOUT_SIG)
{}
//............................................................................
QState Player::initial(Player *me, QEvent const *) {
    static uint8_t registered;            // starts off with 0, per C-standard
    if (!registered) {
        QS_OBJ_DICTIONARY(&l_player);
        QS_OBJ_DICTIONARY(&l_player.m_timeEvt);
        
        QS_FUN_DICTIONARY(&Player::initial);
        QS_FUN_DICTIONARY(&Player::thinking);
        QS_FUN_DICTIONARY(&Player::playing);
        
        registered = (uint8_t)1;
    }
    
    QS_SIG_DICTIONARY(PLAY_SIG, me);               // signal for each Players
    QS_SIG_DICTIONARY(FINISHED_SIG, me);           // signal for each Players
    
    // init wins and losses ctr
    wins = losses = 0;
    
    return Q_TRAN(&Player::thinking); // go to thinking
}
//............................................................................
QState Player::thinking(Player *me, QEvent const *) {
    switch (e->sig) {
        case Q_ENTRY_SIG: {
        // TODO : INITIALIZE BTN
        }
        case BUTTON_SIG: {
            return Q_TRAN(&Player::playing); // go to playing state
        }
    }
    return Q_SUPER(&QHsm::top);
}
//............................................................................
QState Player::playing(Player *me, QEvent const *) {
    switch (e->sig) {
        case Q_ENTRY_SIG: {
            me->m_timeEvt.postIn(me, JOY_TIME); // init joystick update (TIMEOUT_SIG)
            // TODO : INITIALIZE BTN
            return Q_HANDLED();
        }
        case TIMEOUT_SIG: {
            int pos = BSP_joyUpdate();
            HostEvt *pe = Q_NEW(HostEvt, SCROLL_SIG);
            pe->scroll_pos = pos;
            QF::PUBLISH(pe, me);
        }
        case BUTTON_SIG: {
            HostEvt *pe = Q_NEW(HostEvt, SELECT_SIG);
            pe->scroll_pos = 0; // no change
            QF::PUBLISH(pe, me);
        }
        case FINISHED_SIG: {
            if(((HostEvt *)e)->scroll_pos == 1) // win
                wins++;
            else
                losses++;
            
            return Q_TRAN(&Player::thinking); // go to thinking state   
        }                
    }
    return Q_SUPER(&QHsm::top);
}