#include "mbed.h"
#include "Servo.h"

DigitalOut myled(LED1);
AnalogIn battery(p19);
DigitalOut battery_warning(p24);
Serial pc(USBTX, USBRX);
LocalFileSystem local("local");               // Create the local filesystem under the name "local"
Timer t;

void warning_light_check(float);

int main() {
    pc.baud(9600);
    const float BAT_MUL = 10.26;
    const float BAT_LIM = 7.0;
    float sample;
    float voltage;
    
    Servo left_s(p21);
    Servo right_s(p22);
    
    left_s.calibrate_max(0.0007);
    left_s.calibrate_min(-0.0014);
    right_s.calibrate(0.0009);
    
    FILE *fp = fopen("/local/battery.csv", "w");
    fputs("Time,Battery\r\n", fp);
    
    t.start();

    while(1) {
        sample = battery.read();
        voltage = sample*BAT_MUL;
        fprintf(fp, "%f,%f\r\n", t.read(), voltage);
        pc.printf("VBat: %4.3f, ADC: %4.3f, Vadc: %4.3f\r\n", voltage, sample, sample*3.3);
        left_s = 1.0;
        warning_light_check(voltage);
        
        wait(0.5);
        
        sample = battery.read();
        voltage = sample*BAT_MUL;
        fprintf(fp, "%f,%f\r\n", t.read(), voltage);
        pc.printf("VBat: %4.3f, ADC: %4.3f, Vadc: %4.3f\r\n", voltage, sample, sample*3.3);
        left_s = 0.0;
        warning_light_check(voltage);
        
        wait(0.5);
        
        if(voltage < BAT_LIM)
            break;
    }
    fclose(fp);
    myled = 1;   
}

void warning_light_check(float voltage)
{
    if(voltage < 6.4)
        battery_warning = 0;
    else
        battery_warning = 1;
    wait(1);
}
