#include "mbed.h"
#include "Servo.h"

Servo myservo(p23);
Serial pc(USBTX, USBRX);

int main() {
    printf("Servo Calibration Controls:\n");
    printf("1,2,3 - Position Servo (full left, middle, full right)\n");
    printf("4,5 - Increase or Decrease Max position\n");
    printf("6,7 - Increase or Decrease Min position\n");

    float max = 0.0005;
    float min = -0.0005;
    float position = 0.5;
    
    while(1) {                   
        switch(pc.getc()) {
            case '1': position = 0.0; break;
            case '2': position = 0.5; break;
            case '3': position = 1.0; break;
            case '4': max += 0.0001; break; 
            case '5': max -= 0.0001; break; 
            case '6': min += 0.0001; break; 
            case '7': min -= 0.0001; break; 
        }
        printf("position = %.1f, max = %0.4f, min = %0.4f, range = %0.4f\n", position, max, min, (max + -min) / 2.0);
        myservo.calibrate_max(max, 45.0); 
        myservo.calibrate_min(min, 45.0);
        myservo = position;
    }
}
