#include "mbed.h"
#include "buffered_serial.h"
#include "rtos.h"
// Setup: connect p13 and p14 together to create a serial loopback
// Sends out ASCII numbers in a loop and reads them back
// If not the same number LED4 goes on
// LED1 and LED2 indicate RX and TX interrupt routine activity
// LED3 changing indicate main loop running
// if the program is working correctly you should see LED 1, 2, & 3 dimly lit and LED 4 off

BufferedSerial device(p13,p14);  // UART1 - p13, p14

DigitalOut led3(LED3);
DigitalOut led4(LED4);

// Line buffers for sprintf and sscanf
char tx_line[80];
char rx_line[80];

void serial_thread(const void *args)
{
    int i=0;
    int rx_i=0;
    device.baud(9600);

// Formatted IO test using send and receive serial interrupts
// with sprintf and sscanf
    while (1) {
// Loop to generate different test values - send value in hex, decimal, and octal and  then read back
        for (i=0; i<0xFFFF; i++) {
            led3=1;
// Print ASCII number to tx line buffer in hex
            sprintf(tx_line,"%x\r\n",i);
// Copy tx line buffer to large tx buffer for tx interrupt routine
            device.send_line(tx_line);
// Print ASCII number to tx line buffer in decimal
            sprintf(tx_line,"%d\r\n",i);
// Copy tx line buffer to large tx buffer for tx interrupt routine
            device.send_line(tx_line);
// Print ASCII number to tx line buffer in octal
            sprintf(tx_line,"%o\r\n",i);
// Copy tx line buffer to large tx buffer for tx interrupt routine
            device.send_line(tx_line);
            led3=0;
// Read a line from the large rx buffer from rx interrupt routine
            device.read_line(rx_line);
// Read ASCII number from rx line buffer
            sscanf(rx_line,"%x",&rx_i);
// Check that numbers are the same
            if (i != rx_i) led4=1;
// Read a line from the large rx buffer from rx interrupt routine
            device.read_line(rx_line);
// Read ASCII number from rx line buffer
            sscanf(rx_line,"%d",&rx_i);
// Check that numbers are the same
            if (i != rx_i) led4=1;
// Read a line from the large rx buffer from rx interrupt routine
            device.read_line(rx_line);
// Read ASCII number from rx line buffer
            sscanf(rx_line,"%o",&rx_i);
// Check that numbers are the same
            if (i != rx_i) led4=1;
        }
    }
}

// main test program
int main()
{
    Thread thread(serial_thread);
    
    while(1);
}

