#include "mbed.h"
#include "Servo.h"
 
LocalFileSystem local("local");               // Create the local filesystem under the name "local"
BusOut leds(LED1, LED2, LED3, LED4);
 
int main() {
    leds = 0x0;
    float right_pos, left_pos;
    FILE *fp = fopen("/local/config.txt", "r");  // Open "config.txt" for reading
    leds = 0x1;
    fscanf(fp, "r:%f,l:%f", &right_pos, &left_pos);
    leds = 0x2;
    fclose(fp);
    leds = 0x3;
    
    // servos
    Servo left_s(p21);
    Servo right_s(p22);
    
    left_s.calibrate_max(0.0007);
    left_s.calibrate_min(-0.0014);
    right_s.calibrate(0.0009);
    
    leds = 0x4;
    
    left_s = right_s = 1.0;
    
    wait(1);
    
    leds = 0x5;
    
    right_s = right_pos;
    left_s = left_pos;
    
    leds = 0xF;
    
    AnalogIn battery(p19);
    DigitalOut battery_warning(p24);
    battery_warning = 1;

    const float BAT_MUL = 10.26;
    float battery_voltage;
    
    while(1) {
        battery_voltage = battery.read() * BAT_MUL;
        if(battery_voltage < 6.4)
            battery_warning = 0;
        if(battery_warning == 0 && battery_voltage > 6.4)
            battery_warning = 1;
            
        wait(1.0);
    }
}