// file containing configuration values

#ifndef HARP_CONFIG_H
#define HARP_CONFIG_H

#define WAIT_FOR_LOCK   0 // set to 1 to not open log file until gps lock
#define UNLOCK_ON_FALL  1 // set to 1 to not signal parachute untill falling
#define RELEASE_AT_ALT  1 // set to 1 for release at target altitude (must also set UNLOCK_ON_FALL to 1)
#define ALARM           1 // set to 1 to key alarm on descent, 0 = no alarm 
#define WATCHDOG        0 // set to 1 to enable watchdog

const float target_lat = 39.684303;    // for setting the target location!
const float target_lon = -104.470882;

const float course_fudge = 15.0; // if -course_fudge < course > course_fudge then don't turn
const float neg_course_fudge = -15.0;

const float distance_fudge_km = 0.1; // stop turning if within distance_fudge km

const float BAT_GPS_MUL = 16.14; // values for calculating battery voltage
const float BAT_MBED_MUL = 10.35;

const float SERVO_L_MAX = 0.0008; // servo calibration
const float SERVO_L_MIN = -0.0012; // servo calibration
const float SERVO_R_MAX = 0.0006; // servo calibration
const float SERVO_R_MIN = -0.0015; // servo calibration

const float SERVO_RELEASE_MIN = -0.0011;
const float SERVO_RELEASE_MAX = 0.0004;

const int RELEASE_ALT = 4572; // 15k ft in meeters
const int ALARM_ALT = 1981; // altitude to key alarm on descent (6500ft)

const int test_length = 20;
const float test_right[test_length] = {0.2, 0.0, 0.0, 0.0, 0.4, 0.0, 0.0, 0.0, 0.6, 0.0, 0.0, 0.0, 0.8, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0};
const float test_left[test_length] = {1.0, 1.0, 0.8, 1.0, 1.0, 1.0, 0.6, 1.0, 1.0, 1.0, 0.4, 1.0, 1.0, 1.0, 0.2, 1.0, 1.0, 1.0, 0.0, 1.0};

#endif