#include "mbed.h"

#ifndef MBED_GPS_PARSER_H
#define MBED_GPS_PARSER_H

#define NO_LOCK     1
#define NOT_PARSED  2
#define GGA         3
#define GLL         4
#define RMC         5
#define VTG         6

#define PI (3.141592653589793)

/**  A GPS_parser interface for reading from a Globalsat EM-406 GPS Module */
class GPS_Parser
{
public:

    GPS_Parser();

    /** Parse the incoming GPS data, returning whether there is a lock
     *
     * @param line the nmea string to parse, uses tokenizer vs sscanf 
     * @return 1 if there was a lock when the sample was taken (and therefore .longitude and .latitude are valid), else 0
     */
    int parse(char *);
    int get_lock() {
        return lock;
    }
    int get_date() {
        return date;
    }
    float get_time() {
        return utc_time;
    }
    float get_nmea_longitude();
    float get_nmea_latitude();
    float get_dec_longitude();
    float get_dec_latitude();
    float get_msl_altitude();
    float get_course_d();
    float get_speed_k();
    int get_satellites();
    float get_altitude_ft();

    // navigational functions
    float calc_course_to(float, float);
    double calc_dist_to_mi(float, float);
    double calc_dist_to_ft(float, float);
    double calc_dist_to_km(float, float);
    double calc_dist_to_m(float, float);

private:
    float nmea_to_dec(float, char);
    float trunc(float v);
    char *my_token(char *,char);

    char stat_string[128]; // used in my_token
    char *current;
    
    char *field[50]; // used by parse nmea

    // calculated values
    volatile float dec_longitude;
    volatile float dec_latitude;
    volatile float altitude_ft;

    // GGA - Global Positioning System Fixed Data
    volatile float nmea_longitude;
    volatile float nmea_latitude;
    volatile float utc_time;
    volatile char ns, ew;
    volatile int lock;
    volatile int satellites;
    volatile float hdop;
    volatile float msl_altitude;
    volatile char msl_units;

    // RMC - Recommended Minimmum Specific GNS Data
    volatile char rmc_status;
    volatile float speed_k;
    volatile float course_d;
    volatile int date;
};

#endif
