#include "mbed.h"

#ifndef MBED_GPS_H
#define MBED_GPS_H

#define NO_LOCK     1
#define NOT_PARSED  2
#define GGA         3
#define GLL         4
#define RMC         5
#define VTG         6

#define PI (3.141592653589793)

/**  A GPS interface for reading from a Globalsat EM-406 GPS Module */
class GPS {
public:

    /** Create the GPS interface, connected to the specified serial port
     */    
    GPS(PinName tx, PinName rx);
    
    /** Sample the incoming GPS data, returning whether there is a lock
     * 
     * @return 1 if there was a lock when the sample was taken (and therefore .longitude and .latitude are valid), else 0
     */
    int sample();
    float get_nmea_longitude();
    float get_nmea_latitude();
    float get_dec_longitude();
    float get_dec_latitude();
    float get_msl_altitude();
    float get_course_t();
    float get_course_m();
    float get_speed_k();
    float get_speed_km();
    int get_satelites();
    float get_altitude_ft();
    
    // navigational functions
    float calc_course_to(float, float);
    double calc_dist_to_mi(float, float);
    double calc_dist_to_ft(float, float);
    double calc_dist_to_km(float, float);
    double calc_dist_to_m(float, float);
    
#ifdef OPEN_LOG
    void start_log(void);
    void new_file(void);
    void stop_log(void);
#endif    
    
private:
    float nmea_to_dec(float, char);
    float trunc(float v);
    void getline();
    void format_for_log(void);
    
    Serial _gps;
    char msg[1024];
    char bfr[1030];
    bool is_logging;
#ifdef OPEN_LOG
    Logger _openLog;
#endif
    // calculated values
    float dec_longitude;
    float dec_latitude;
    float altitude_ft;
    
    // GGA - Global Positioning System Fixed Data
    float nmea_longitude;
    float nmea_latitude;    
    float utc_time;
    char ns, ew;
    int lock;
    int satelites;
    float hdop;
    float msl_altitude;
    char msl_units;
    
    // RMC - Recommended Minimmum Specific GNS Data
    char rmc_status;
    float speed_k;
    float course_d;
    int date;
    
    // GLL
    char gll_status;
    
    // VTG - Course over ground, ground speed
    float course_t; // ground speed true
    char course_t_unit;
    float course_m; // magnetic
    char course_m_unit;
    char speed_k_unit;
    float speed_km; // speek km/hr
    char speed_km_unit;
};

#endif
