#include "mbed.h"

I2C compass(p9,p10);

Serial pc(USBTX, USBRX); // tx, rx

const int addr = 0xC0;  // define the I2C Address

void calibrate();

int main()
{
    char data[2];
    char cmd[2];
    int bearing_raw;
    float bearing;
    pc.baud(9600);
    
    //calibrate();

    while(1) {
        cmd[0] = 0x2;
        compass.write(addr,cmd,1,true);
        compass.read(addr,data,2,false);

        bearing_raw = (data[0] << 8) + data[1];
        bearing = bearing_raw / 10.0;

        pc.printf("data[0] = 0x%x, data[1] = 0x%x, raw = 0x%x, bearing = %f\r\n", data[0], data[1], bearing_raw, bearing);

        wait(0.640);
    }
}

void calibrate()
{
    char data[2];
    data[0] = 22;
    pc.puts("Make sure the Device is on a level surface.\r\n");
    pc.puts("Point the Device North.\r\n");
    pc.puts("Press enter to continue.\r\n");
    pc.getc();
    data[1] = 0xF0;
    compass.write(addr,data,2,false);
    pc.puts("Point the Device East (+90).\n\r");
    pc.puts("Press enter to continue.\r\n");
    pc.getc();
    data[1] = 0xF5;
    compass.write(addr,data,2,false);
    pc.puts("Point the Device South (+180).\n\r");
    pc.puts("Press enter to continue.\r\n");
    pc.getc();
    compass.write(addr,data,2,false);
    pc.puts("Point the Device West (+270).\n\r");
    pc.puts("Press enter to continue.\r\n");
    pc.getc();
    compass.write(addr,data,2,false);
}