#include "mbed.h"
#include "TextLCD.h"
#include "bsp.h"

TextLCD lcd(p10, p11, p17, p18, p19, p20); // rs, e, d4-d7
AnalogIn joystick(p16);
DigitalIn selectPin(p13);

//............................................................................
int BSP_joyUpdate() {
    int pos = joystick.read()*100;
    if (pos < 40)
        return JOY_DOWN;  // going down
    else if (pos > 60)
        return JOY_UP; // going up
    else
        return JOY_CENTER;
}
//............................................................................
void BSP_lcdScrollIn(char* line1, char* line2) {
// scroller algorithm
    lcd.cls();
    char output1[17];
    char output2[17];
    for ( int i = 0; i < 17; i++) {
        output1[i] = ' ';
        output2[i] = ' ';
    }
    for (int i = 0; i < 17; i++) {
        for (int col = 0; col < 17; col++) {

            if (col >= i) {
                output1[col] = ' ';
                output2[col] = ' ';
            } else {
                output1[col] = (line1[col+(16-i)]);
                output2[col] = (line2[col+(16-i)]);
            }
            lcd.locate(col,0);
            lcd.putc(output1[col]);
            lcd.locate(col,1);
            lcd.putc(output2[col]);
        }
        wait(0.4);
    }
}
//............................................................................
void BSP_lcdUpdate(char* line1,char* line2) {
TextLCD lcd(p10, p11, p17, p18, p19, p20); // rs, e, d4-d7
    uint8_t length1 = strlen(line1);
    uint8_t length2 = strlen(line2);
    lcd.cls();
    for (int col = 0; col < 17; col++) {
        if (col < length1) {
            lcd.locate(col,0);
            lcd.putc(*(line1+col));
        }
        if (col < length2) {
            lcd.locate(col,1);
            lcd.putc(*(line2+col));
        }
    }
}
//............................................................................
char* itoa(int val, int base) {
    static char buf[BUFF_LEN] = {0};
    int i = BUFF_LEN-2;
    for (; val && i ; --i, val /= base)
        buf[i] = "0123456789abcdef"[val % base];

    return &buf[i+1];
}
//............................................................................
char* cat(char* first, char* second, char* output) {
    size_t len1 = strlen(first);
    size_t len2 = strlen(second);
    size_t outlen = strlen(output);
    bool done = false;
    int i = 0;

    static char buf[BUFF_LEN] = {0};
    for(; i < len1 && !done; i++)
    {
        if(i == (BUFF_LEN-1)){ done = true; break; }
        buf[i] = first[i];
    }
    for(int b = 0; b < len2 && !done; i++, b++)
    {
        if(i == (BUFF_LEN-1)){ done = true; break; }
        buf[i] = second[b];    
    }
    for(;i < outlen && !done; i++)
    {
        if(i == (BUFF_LEN-1)){ done = true; break; }
        buf[i] = ' ';
    }
    return &buf[0];
}
//............................................................................