#include "mbed.h"
#include "AHRS.h"
#include "rtos.h"

IMU imu;
Serial pc(USBTX, USBRX);

void imu_thread(void const *arg)
{
    float data[4];
    imu.loop(data);
    pc.printf("#YPR=%f,%f,%f\t%f\r\n", data[1],data[2],data[3],data[0]);
}

int main()
{
    pc.baud(9600);

    RtosTimer ahrs_timer(imu_thread, osTimerPeriodic, NULL);
    ahrs_timer.start(20);

    while (1);
}