#include "mbed.h"
#include <vector>
#define BUFFER_SIZE 16
#define NUMBER_OF_SLICES 120
#include "MRF24J40.h"

//push data pins
DigitalOut pushRegister(p24);
DigitalOut pushBit(p23);

//write to arm pins
DigitalOut dataArmOne(p15);
DigitalOut dataArmTwo(p16);
DigitalOut dataArmThree(p17);
DigitalOut dataArmFour(p18);
DigitalOut dataArmFive(p19);
DigitalOut dataArmSix(p20);
DigitalOut dataArmSeven(p21);
DigitalOut dataArmEight(p22);

//hass sensor interupt
InterruptIn hallSensor(p25);

//Set Up Timer and ticker
Timer rotationTime;
Ticker updateLeds;

//Declare global vars
double slice_time;
double rotate_time; 
int current_slice;
char slice_data [NUMBER_OF_SLICES][16]; //[slice][specific led distance] (0 is closest) & with approppriate bit for each arm 
bool firstTime;


//serial port for pc and bluetooth
Serial pc(USBTX, USBRX); // tx, rx
Serial bt(p9, p10);// tx, rx

//define variables for ziggbee
MRF24J40 mrf(p11, p12, p13, p14, p26);
char rxBuffer[128];
char txBuffer[128];
int rxLen;
char buffer [4];


int rf_receive(char *data, uint8_t maxLength)
{
    uint8_t len = mrf.Receive((uint8_t *)data, maxLength);
    uint8_t header[8]= {1, 8, 0, 0xA1, 0xB2, 0xC3, 0xD4, 0x00};

    if(len > 10) {
        //Remove the header and footer of the message
        for(uint8_t i = 0; i < len-2; i++) {
            if(i<8) {
                //Make sure our header is valid first
                if(data[i] != header[i])
                    return 0;
            } else {
                data[i-8] = data[i];
            }
        }

        //pc.printf("Received: %s length:%d\r\n", data, ((int)len)-10);
    }
    return ((int)len)-10;
}
void recievePoint (int slice, int distance, char addChar, char operation){
    //pc.printf("recieved %i %i %X %c \r\n" , slice, distance, addChar, operation);
    if (operation == 'x'){
        //pc.printf("odl slice data with x %X is \r\n", slice_data[slice][distance]);
        slice_data [slice] [distance] ^= addChar;
        //pc.printf("new slice data with X %X is \r\n", slice_data[slice][distance]);
        return;
    }
    if (operation == 'o'){
       // pc.printf("odl slice data with o %X is \r\n", slice_data[slice][distance]);
        slice_data [slice] [distance] |= addChar;
        //pc.printf("new slice data with 0 %X is \r\n", slice_data[slice][distance]);
        return;
    }
    if (operation == 'a'){
        slice_data [slice] [distance] = slice_data[slice][distance] & addChar;
        return;
    }
}

void pushData (char bits [16]){
  
 // pc.printf("pushing data \r\n");
  for (int i = 8; i < 16; i ++){
    dataArmOne = bits [i] & 0x01;
    dataArmTwo = bits [i] & 0x02;
    dataArmThree = bits [i]& 0x04;
    dataArmFour = bits [i]& 0x08;
    dataArmFive = bits [i] & 0x10;
    dataArmSix = bits [i] & 0x20;
    dataArmSeven = bits [i] & 0x40;
    dataArmEight = bits [i] & 0x80;
    
    pushBit = 1;
    pushBit = 0;
  }
  for (int i = 7; i >= 0; i --){
    dataArmOne = bits [i] & 0x01;
    dataArmTwo = bits [i] & 0x02;
    dataArmThree = bits [i]& 0x04;
    dataArmFour = bits [i]& 0x08;
    dataArmFive = bits [i] & 0x10;
    dataArmSix = bits [i] & 0x20;
    dataArmSeven = bits [i] & 0x40;
    dataArmEight = bits [i] & 0x80;
    
    pushBit = 1;
    pushBit = 0;
    }
      
  pushRegister = 1;
  pushRegister = 0;
}


//periodic display interrupt
void nextLedPush(){
 // pc.printf("next led push");
  if (current_slice < NUMBER_OF_SLICES){
    pushData(slice_data[current_slice]);
    current_slice ++;
  } else {
      updateLeds.detach();
  }
}

//Hall sensor interupt
void rotate_sense(){
 // pc.printf("interupt");
  if (firstTime){
    rotationTime.reset();
    rotationTime.start();
    firstTime = false;
  //  pc.printf(" first time");
    return;
  }
    if(current_slice < NUMBER_OF_SLICES / 4){
      return;
    }
 // pc.printf(" seconod time \n");
    rotate_time = rotationTime.read_us();
    rotationTime.reset();    
    rotationTime.start();
    
    slice_time = (double) rotate_time/NUMBER_OF_SLICES;
    current_slice = 0;
    updateLeds.attach_us(&nextLedPush, slice_time);
}

void didRecievePoint(){
}


int main() {
    pc.printf("started");
    firstTime = true;
    current_slice = 100;
    
    uint8_t channel = 2;
    mrf.SetChannel(channel);
    
    hallSensor.fall(&rotate_sense);
    
 /*   for (int i = 0; i < 60; i ++){
        slice_data [i][0] = 0x11; // bit 0 is high on arm 0
        slice_data [i][1] = 0x11;
        slice_data [i][2] = 0x11;
        slice_data [i][3] = 0x11;
        slice_data [i][4] = 0x11;
        slice_data [i][5] = 0x11;
        slice_data [i][6] = 0x11;
        slice_data [i][7] = 0x11; 
        slice_data [i][8] = 0x11;
        slice_data [i][9] = 0x11;
        slice_data [i][10] = 0x11;
        slice_data [i][11] = 0x11;
        slice_data [i][12] = 0x11;
        slice_data [i][13] = 0x11;
        slice_data [i][14] = 0x11;
        slice_data [i][15] = 0x11;
    }*/
    /*
    for (int i = 0; i < 60; i ++){
        slice_data [i][0] = 0x00; // bit 0 is high on arm 0
        slice_data [i][1] = 0x00;
        slice_data [i][2] = 0x00;
        slice_data [i][3] = 0x00;
        slice_data [i][4] = 0x00;
        slice_data [i][5] = 0x00;
        slice_data [i][6] = 0x08;
        slice_data [i][7] = 0x00;
        slice_data [i][8] = 0x00;
        slice_data [i][9] = 0x00;
        slice_data [i][10] = 0x00;
        slice_data [i][11] = 0x00;
        slice_data [i][12] = 0x00;
        slice_data [i][13] = 0x00;
        slice_data [i][14] = 0x00;
        slice_data [i][15] = 0x00;
    }
        
    for (int i = 60; i < 120; i++){
        slice_data [i][0] = 0x00; // bit 0 is high on arm 0
        slice_data [i][1] = 0x00;
        slice_data [i][2] = 0x00;
        slice_data [i][3] = 0x00;
        slice_data [i][4] = 0x08;
        slice_data [i][5] = 0x00;
        slice_data [i][6] = 0x00;
        slice_data [i][7] = 0x00;
        slice_data [i][8] = 0x00;
        slice_data [i][9] = 0x00;
        slice_data [i][10] = 0x00;
        slice_data [i][11] = 0x00;
        slice_data [i][12] = 0x00;
        slice_data [i][13] = 0x00;
        slice_data [i][14] = 0x00;
        slice_data [i][15] = 0x00;
    }
    */
    slice_data [60][15] = 0xFF;
    for (int i = 0; i < 120; i ++){
        for (int j = 0; j < 16; j++){
            slice_data [i][j] = 0x00;
           // if (j == 14){
             //   slice_data [i][j] = 0x01;
           // }
            
        }
    }
    slice_data[60][14] = 0xFF;
    
    while(true) {
        
        //Try to receive some data
        rxLen = rf_receive(rxBuffer, 128);
        if(rxLen > 0) {
            int  slice = (int) rxBuffer[0];
            int distance = (int) rxBuffer[1];
            char addChar = (char) rxBuffer[2];
            char operation = (char) rxBuffer[3];
            
            //pc.printf("we got his from the buffer slice %i distance %i char %X operation %c \r\n", slice, distance, addChar, operation);
            recievePoint(slice, distance, addChar, operation);
            //TODO this means we got a 
            //char 
        }
    }
}
