// Program monitors the temperature recorded on the EA LPCXpresso board's U7
// There is an option to either display the temperature on the OLED or write to an SD card
// If writing to an SD card, be sure to only unplug the MBED or remove the SD card when LED3 is illuminated
// Removing power or the SD card when LED3 is not illuminated will result in a loss of data
// Temperature is monitored every 6 seconds in the current code

#include "mbed.h"
#include "EAOLED.h"
#include "SDFileSystem.h"

SDFileSystem sd(p5, p6, p7, p24, "sd"); //Used for file system writes to the EA SD card.  Comment this out if displaying on OLED. Make sure J55 pins 1&2 (A) are disconnected!
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
//EAOLED oled(p5, p6, p7, p8, p25); // mosi, dnc, sclk, cs, power ***this is only used if displaying temp on OLED instead of file writing***
InterruptIn sense(p8); //make sure EA board J25 is set to PIO0_2  ***if using the OLED, must change this to pin 10 and connect wire from J25 center pin to pin10 on mBed, make sure J25 does not have a jumper populated***

Timeout timeout; //timeout used for calculation of frequency
int edgecount, on, et;
float temp, freq, tempf;

void edge(){
    edgecount = edgecount++;
}

void attimeout(){
    on = 0;
}

int main() {
//    oled.cls(); //*** make sure this is not commented out if using the OLED
//    oled.locate(0,0); //*** make sure this is not commented out if using the OLED
//    oled.printf("Frequency:"); //*** make sure this is not commented out if using the OLED
//    oled.locate(0,2); //*** make sure this is not commented out if using the OLED
//    oled.printf("Temperature:"); //*** make sure this is not commented out if using the OLED
    myled1 = 1; //indicates the program is running
    FILE *fp = fopen("/sd/temperat.csv", "w"); //formats the file header. Comment this out if using the OLED.
    fprintf(fp,"Time, Freq, TempC, TempF\n"); //Comment this out if using the OLED
    fclose(fp); //Comment this out if using the OLED
    et = 0; //Sets elapsed time to 0.  Can comment this out if using OLED.
    
    while(1){
        myled2 = 0; //indicates temperature is not being monitored.  Can be commented out if using OLED.
        myled3 = 1; //indicates safe to remove power or SD card.  Can be commented out if using OLED.
        wait(1); //wait time to allow for safe card removal or powerdown.  Can be commented out if using OLED.
        myled2 = 1; //indicates the temperature is being monitored.  Can be commented out if using OLED.
        myled3 = 0; //indicates not safe to remove SD card or power.  Can be commented out if using OLED.

        FILE *fp = fopen("/sd/temperat.csv", "a"); //comment this out if using the OLED

        on=1;
        edgecount = 0;
        timeout.attach(&attimeout, 5); //sets the amount of time used to calcuate the frequency of the temp sensor
        while(on){
            sense.rise(&edge); //tracks the rising edge of the temp sensor
        }
        
        freq = (float)(edgecount)/5;  //calculates the frequency.  Change the divisior if changing the timeout.attach()
//        oled.locate(0,1); //*** make sure this is not commented out if using the OLED
//        oled.printf("%4.3f", freq); //*** make sure this is not commented out if using the OLED
        temp = freq;
        temp = 1/temp; //changes frequency into period
        temp = temp*100000; //provides appropriate modifier if J26 is set to GND, GND.
        temp = temp-273.15;  //calculates the temperature in degrees C
//        oled.locate(0,3); //*** make sure this is not commented out if using the OLED
//        oled.printf("%2.3f", temp); //*** make sure this is not commented out if using the OLED
        tempf = 9*temp;
        tempf = tempf/5;
        tempf = tempf + 32; //calcualtes the temperature in degrees F
//        oled.locate(0,4); //*** make sure this is not commented out if using the OLED
//        oled.printf("%2.3f", tempf); //*** make sure this is not commented out if using the OLED
        et = et+6; //Calculates the elaped time in seconds. If changing the timeout or the wait time for SD safe removal, you must change this accordingly. Comment this out if using the OLED
        fprintf(fp,"%d, %4.3f, %2.3f, %2.3f\n", et, freq, temp, tempf); //Comment this out if using the OLED
        fclose(fp); //Comment this out if using the OLED
    }
}
