/**
 * Fast AD9850 serial interface over SPI
 */

#include <mbed.h>

class AD9850SPI {

public:
    AD9850SPI(SPI &spi, PinName fq_ud, PinName reset);
    ~AD9850SPI();

    void reset_spi();
    void reset();
    void setFrequency(int freq, int powerdown=0, int phase=0);

private:
    SPI &_spi;
    DigitalOut _fq_ud;
    DigitalOut _reset;
};

