#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "C12832.h"

EthernetInterface eth;
HTTPClient http;
char str[512];

C12832 lcd(p5, p7, p6, p8, p11);

int main() 
{
    eth.init(); //Use DHCP

    eth.connect();
    

    
    //GET data
    
    lcd.cls();
    lcd.locate(0,3);   
    lcd.printf("\nTrying to fetch page...\n");
    int ret = http.get("http://mbed.org/media/uploads/donatien/hello.txt", str, 128);
    if (!ret)
    {
      lcd.cls();
      lcd.locate(0,3);       
      lcd.printf("Page fetched successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      lcd.cls();
      lcd.locate(0,3); 
      lcd.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("Hello", "World");
    map.put("test", "1234");
    lcd.cls();
    lcd.locate(0,3); 
    lcd.printf("\nTrying to post data...\n");
    ret = http.post("http://httpbin.org/post", map, &inText);
    if (!ret)
    {
      lcd.cls();
      lcd.locate(0,3); 
      lcd.printf("Executed POST successfully - read %d characters\n", strlen(str));
      lcd.printf("Result: %s\n", str);
    }
    else
    {
      lcd.cls();
      lcd.locate(0,3); 
      lcd.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //PUT data
    strcpy(str, "This is a PUT test!");
    HTTPText outText(str);
    //HTTPText inText(str, 512);
    lcd.cls();
    lcd.locate(0,3); 
    lcd.printf("\nTrying to put resource...\n");
    ret = http.put("http://httpbin.org/put", outText, &inText);
    if (!ret)
    {
      lcd.cls();
      lcd.locate(0,3); 
      lcd.printf("Executed PUT successfully - read %d characters\n", strlen(str));
      lcd.printf("Result: %s\n", str);
    }
    else
    {
      lcd.cls();
      lcd.locate(0,3); 
      lcd.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    //DELETE data
    //HTTPText inText(str, 512);
    lcd.cls();
    lcd.locate(0,3); 
    lcd.printf("\nTrying to delete resource...\n");
    ret = http.del("http://httpbin.org/delete", &inText);
    if (!ret)
    {
      lcd.cls();
      lcd.locate(0,3); 
      lcd.printf("Executed DELETE successfully - read %d characters\n", strlen(str));
      lcd.printf("Result: %s\n", str);
    }
    else
    {
      lcd.cls();
      lcd.locate(0,3); 
      lcd.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
    }
    
    eth.disconnect();  

    while(1) {
    }
}
