#include "mbed.h"
#include "PinDetect.h"
#include "USBKeyboard.h"

//Serial pc(USBTX, USBRX);

AnalogIn x_in(A0);
AnalogIn y_in(A1);
AnalogIn z_in(A2);

USBKeyboard keyboard;
PinDetect start_button(D6);
PinDetect up_button(D5);
PinDetect down_button(D4);
PinDetect right_button(D8);
PinDetect left_button(D7);
PinDetect a_button(D9);

int main() {
    start_button.mode(PullUp);
    up_button.mode(PullUp);
    down_button.mode(PullUp);
    right_button.mode(PullUp);
    left_button.mode(PullUp);
    
    while(1) {
        
        if (x_in.read() > .8 || y_in.read() > .8 || z_in.read() > .8) {
            keyboard.printf("%s", "a");
        } else if (start_button == 0) {
            keyboard.keyCode(32);
        } else if (up_button == 0) {
            keyboard.keyCode(UP_ARROW);
        } else if (down_button == 0) {
            keyboard.keyCode(DOWN_ARROW);
        } else if (right_button == 0) {
            keyboard.keyCode(RIGHT_ARROW);
        } else if (left_button == 0) {
            keyboard.keyCode(LEFT_ARROW);
        } else if (a_button ==0) {
            keyboard.printf("%s", "a");
        }
    }
}
