#include "mbed.h"
#include "PinDetect.h"
#include <string>
#include <ctime>
#include "USBKeyboard.h"


Serial pc(USBTX, USBRX);
PinDetect input4(D4);
PinDetect input5(D5);
PinDetect input6(D6);
PinDetect input7(D7);
PinDetect input8(D8);
PinDetect input9(D9);
PinDetect input10(D10);
PinDetect input11(D11);
PinDetect input12(D12);
PinDetect input13(D13);
USBKeyboard keyboard;


int main() {
    time_t seconds_since_last_action = time(NULL);
    clock_t begin = clock();
    string last_action = "";
    double buffer_time = 50.0;
    while(1) {
        if (input4 == 0) {
            if (double(clock()-begin) < buffer_time) { // move to next letter
                if (last_action.compare("w") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "x");
                    last_action = "X";
                } else if (last_action.compare("x") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "w");
                    last_action = "w";
                } else {
                    keyboard.printf("%s", "w");
                    last_action = "w";
                }
            } else {
                keyboard.printf("%s", "w");
                last_action = "w";
            }
            wait(0.3);
            begin = clock();
        } else if (input5 == 0) {
            pc.printf("%s", "QRS");
            if (double(clock()-begin) < buffer_time) { // move to next letter
                if (last_action.compare("q") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "r");
                    last_action = "r";
                } else if (last_action.compare("r") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "s");
                    last_action = "s";
                } else if (last_action.compare("r") == 0 || last_action.compare("s") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "q");
                    last_action = "q";
                } else {
                    keyboard.printf("%s", "q");
                    last_action = "q";
                }
            } else {
                keyboard.printf("%s", "q");
                last_action = "q";
            }
            wait(0.3);
            begin = clock();
        } else if (input6 == 0) {
            pc.printf("%s", "IJKL");
            if (double(clock()-begin) < buffer_time) { // move to next letter
                if (last_action.compare("i") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "j");
                    last_action = "j";
                } else if (last_action.compare("j") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "k");
                    last_action = "k";
                } else if (last_action.compare("k") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "l");
                    last_action = "l";
                } else if (last_action.compare("j") == 0 || last_action.compare("k") == 0 || last_action.compare("l") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "i");
                    last_action = "i";
                } else {
                    keyboard.printf("%s", "i");
                    last_action = "i";
                }
            } else {
                keyboard.printf("%s", "i");
                last_action = "i";
            }
            wait(0.3);
            begin = clock();
        } else if (input7 == 0) {
            pc.printf("%s", "ABCD");
            if (double(clock()-begin) < buffer_time) { // move to next letter
                if (last_action.compare("a") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "b");
                    last_action = "b";
                } else if (last_action.compare("b") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "c");
                    last_action = "c";
                } else if (last_action.compare("c") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "d ");
                    last_action = "d";
                } else if (last_action.compare("b") == 0 || last_action.compare("c") == 0 || last_action.compare("d") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "a");
                    last_action = "a";
                } else {
                    keyboard.printf("%s", "a");
                    last_action = "a";
                }
            } else {
                keyboard.printf("%s", "a");
                last_action = "a";
            }
            wait(0.3);
            begin = clock();
        } else if (input8 == 0) {
            pc.printf("%s", "space");
            keyboard.keyCode(32);
            last_action = "space";
            wait(0.3);
        } else if (input9 == 0) {
            pc.printf("%s", "YZ");
            if (double(clock()-begin) < buffer_time) {
                if (last_action.compare("y") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "z");
                    last_action = "z";
                } else if (last_action.compare("z") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "y");
                    last_action = "y";
                } else {
                    keyboard.printf("%s", "y");
                    last_action = "y";
                }
            } else {
                keyboard.printf("%s", "y");
                last_action = "y";
            }
            wait(0.3);
            begin = clock();
        } else if (input10 == 0) {
            pc.printf("%s", "TUV");
            if (double(clock()-begin) < buffer_time) { // move to next letter
                if (last_action.compare("t") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "u");
                    last_action = "u";
                } else if (last_action.compare("u") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "v");
                    last_action = "v";
                } else if (last_action.compare("u") == 0 || last_action.compare("v") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "t");
                    last_action = "t";
                } else {
                    keyboard.printf("%s", "t");
                    last_action = "t";
                }
            } else {
                keyboard.printf("%s", "t");
                last_action = "t";
            }
            wait(0.3);
            begin = clock();
        } else if (input11 == 0) {
            pc.printf("%s", "MNOP");
            if (double(clock()-begin) < buffer_time) { // move to next letter
                if (last_action.compare("m") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "n");
                    last_action = "n";
                } else if (last_action.compare("n") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "o");
                    last_action = "o";
                } else if (last_action.compare("o") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "p");
                    last_action = "p";
                } else if (last_action.compare("n") == 0 || last_action.compare("o") == 0 || last_action.compare("p") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "m");
                    last_action = "m";
                } else {
                    keyboard.printf("%s", "m");
                    last_action = "m";
                }
            } else {
                keyboard.printf("%s", "m");
                last_action = "m";
            }
            wait(0.3);
            begin = clock();
        } else if (input13 == 0) {
            pc.printf("%s", "EFGH");
            if (double(clock()-begin) < buffer_time) { // move to next letter
                if (last_action.compare("e") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "f");
                    last_action = "f";
                } else if (last_action.compare("f") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "g");
                    last_action = "g";
                } else if (last_action.compare("g") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "h");
                    last_action = "h";
                } else if (last_action.compare("f") == 0 || last_action.compare("g") == 0 || last_action.compare("h") == 0) {
                    keyboard.keyCode(8);
                    keyboard.printf("%s", "e");
                    last_action = "e";
                } else {
                    keyboard.printf("%s", "e");
                    last_action = "e";
                }
            } else {
                keyboard.printf("%s", "e");
                last_action = "e";
            }
            wait(0.3);
            begin = clock();
        } else if (input12 == 0) {
            pc.printf("%s", "DELETE");
            keyboard.keyCode(8);
            last_action = "delete";
            wait(0.3);
            begin = clock();
        }
    }
}



