#include "main.h"

int main() {
    States status = PATROL;
    drive_stop();
    setup_usb();
    set_boardleds(0, 0, 0, 0);
    while(1) {
      switch(status) {
        case PATROL:
            status = patrol_state();
            break;
        case SEARCH:
            status = search_state();
            break;
        case ALERT:
            status = alert_state();
            break;
      }
    }
}

States patrol_state() {
    int range = 0;
    lcd_newmessage("PATROL STATE.\n");
    set_boardleds(1, 0, 0, 0);
    set_rgb_f(0.0, 0.0, 1.0);
    range = read_distance();
    if(range < 40) {
        drive_backward();
    } else if(range < 80) {
        drive_turnRight();
    } else {
        drive_forward();
    }
    wait_ms(300);

    if(hear_sound() ) {
        drive_stop();
        return SEARCH;
    } else {
        return PATROL;
    }
}

States search_state() {
    static int counter = 0;
    if(counter == 0) {
        lcd_newmessage("SEARCH STATE...\n");
        set_boardleds(0, 1, 0, 0);
        set_rgb(0, 255, 255);
        wait_ms(5000);
        counter = 50;
    }

    wait_ms(100);
    if(motion_detected() ) {
        set_boardleds(0, 0, 0, 1);
        counter = 0;
        return ALERT;
    }
    counter--;
    if(counter > 0) {
        return SEARCH;   
    } else { //counter == 0
        return PATROL;
    }
}

States alert_state() {
    static int counter = 0;
    if(counter == 0) {
        lcd_newmessage("ALERT STATE!!!\n");
        set_rgb(0, 255, 0);
        send_email();
        play_usbfile("bark.wav");
    }

    set_boardleds(counter % 3, !(counter % 7), counter % 5, 1);
    
    if(counter % 4 == 0) {
        drive_pivotLeft();
    } else if(counter % 4 == 2) {
        drive_pivotRight();
    }

    wait_ms(100);
    
    if(counter >= 100) {
        drive_stop();
        counter = 0;
        return PATROL;
    } else {
        counter++;
        return ALERT;
    }
}
