#include "mbed.h"
#include "traffic_light.h"

trafficLight::trafficLight(PinName r, PinName g, PinName b) 
    :   rpin(r)
    ,   gpin(g)
    ,   bpin(b)
    {};

void trafficLight::setState(lightState s) {
    switch (s) {
        case RED:       red(); break;       //Change led color
        case ORANGE:    orange(); break;    //
        case GREEN:     green(); break;     //
    }
    currState = s;              //Change current state
}

void trafficLight::clear() {    //Clear the led color
    PwmLED(rpin, 0);
    PwmLED(gpin, 0);
    PwmLED(bpin, 0);
    
}

void trafficLight::red() {      //Change led to red
    clear();
    PwmLED(rpin, 255);
}

void trafficLight::orange() {   //Change led to orange
    clear();
    PwmLED(rpin, 255);
    PwmLED(gpin, 42);
    PwmLED(bpin, 0);
};

void trafficLight::green() {    //Change led to green
    clear();
    PwmLED(gpin, 255);
}