#include "mbed.h"

enum lightState{                                    //States the light can be on
    RED,
    ORANGE,
    GREEN
};

struct PwmLED {                                     //Easy led color changer (with rgb led only 1 color!)
    PwmLED(PinName pin, int rgb_val) {
        PwmOut led(pin);
        led.period_ms(1);
        led = rgb_val / 255.0;
    }
};

class trafficLight{
    public:
    trafficLight(PinName r, PinName g, PinName b);  //Constructor
    lightState getState() { return currState; }     //Return the state the light is current on
    void setState(lightState s);                    //Change the light to a different state
    
    private:
    void red();     //Set state to red
    void orange();  //Set state to orange
    void green();   //Set state to green
    
    void clear();
    
    lightState currState;
    PinName rpin;
    PinName bpin;
    PinName gpin;
};    