#include "mbed.h"

class Sonar{
    public:
    Sonar(PinName trig, PinName echo);
    float getDistance();
    float getLastDistance() {return _distance;}
    void autoPulse(bool on_off, float frequency_ms = 1);
    void pulse();
    
    private:
    Ticker _ticker;
    Timer _timer;
    DigitalOut _trig;
    InterruptIn _echo;
    
    int _begin;
    int _end;
    float _distance;
    bool _pinged;
    
    void echoBegin();
    void echoEnd();
};